/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.claims;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.claims.RequestedClaim;
import com.microsoft.identity.client.claims.RequestedClaimAdditionalInformation;
import java.lang.reflect.Type;
import java.util.List;

class ClaimsRequestDeserializer
implements JsonDeserializer<ClaimsRequest> {
    ClaimsRequestDeserializer() {
    }

    public ClaimsRequest deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ClaimsRequest claimsRequest = new ClaimsRequest();
        this.addProperties(claimsRequest.getAccessTokenClaimsRequested(), json.getAsJsonObject().getAsJsonObject("access_token"), context);
        this.addProperties(claimsRequest.getIdTokenClaimsRequested(), json.getAsJsonObject().getAsJsonObject("id_token"), context);
        this.addProperties(claimsRequest.getUserInfoClaimsRequested(), json.getAsJsonObject().getAsJsonObject("userinfo"), context);
        return claimsRequest;
    }

    private void addProperties(List<RequestedClaim> claimList, JsonObject addTo, JsonDeserializationContext context) {
        if (addTo == null) {
            return;
        }
        for (String key : addTo.keySet()) {
            RequestedClaim claim = new RequestedClaim();
            claim.setName(key);
            JsonElement element = addTo.get(key);
            if (!(element instanceof JsonNull)) {
                RequestedClaimAdditionalInformation additionalInformation = (RequestedClaimAdditionalInformation)context.deserialize((JsonElement)addTo.getAsJsonObject(key), RequestedClaimAdditionalInformation.class);
                claim.setAdditionalInformation(additionalInformation);
            }
            claimList.add(claim);
        }
    }
}

