/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.widget.Toast;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskBrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;

public final class CurrentTaskBrowserTabActivity
extends Activity {
    private static final String TAG = CurrentTaskBrowserTabActivity.class.getSimpleName();
    private static final int REDIRECT_RECEIVED_CODE = 2;
    private BroadcastReceiver mCloseBroadcastReceiver;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String methodTag = TAG + ":onCreate";
        String response = this.getIntent().getDataString();
        if (savedInstanceState == null && this.getIntent() != null && !StringUtil.isEmpty((String)this.getIntent().getDataString())) {
            Intent responseIntent = CurrentTaskBrowserAuthorizationFragment.createCustomTabResponseIntent((Context)this, (String)response);
            if (responseIntent != null) {
                this.startActivityForResult(responseIntent, 2);
            } else {
                Logger.warn((String)methodTag, (String)"Received NULL response intent. Unable to complete authorization.");
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Unable to complete authorization as there is no interactive call in progress. This can be due to closing the app while the authorization was in process.", (int)1).show();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        final String methodTag = TAG + ":onActivityResult";
        if (resultCode == 0) {
            Intent broadcast = new Intent("redirect_returned_action");
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
            this.mCloseBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    boolean hasNullTaskAffinity = false;
                    PackageManager packageManager = CurrentTaskBrowserTabActivity.this.getApplicationContext().getPackageManager();
                    try {
                        ActivityInfo activityInfo;
                        ComponentName componentName = CurrentTaskBrowserTabActivity.this.getComponentName();
                        ActivityInfo activityInfo2 = activityInfo = componentName != null ? packageManager.getActivityInfo(componentName, 0) : null;
                        if (activityInfo == null || activityInfo.taskAffinity == null) {
                            hasNullTaskAffinity = true;
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Logger.warn((String)methodTag, null, (String)("Package name not found for: " + CurrentTaskBrowserTabActivity.this.getComponentName()));
                    }
                    CurrentTaskBrowserTabActivity.this.finishActivity(2);
                    if (Build.VERSION.SDK_INT > 21 && hasNullTaskAffinity) {
                        CurrentTaskBrowserTabActivity.this.finishAndRemoveTask();
                    } else {
                        CurrentTaskBrowserTabActivity.this.finish();
                    }
                }
            };
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mCloseBroadcastReceiver, new IntentFilter("destroy_redirect_receiving_activity_action"));
        }
    }

    protected void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mCloseBroadcastReceiver);
        super.onDestroy();
    }
}

