/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Identity;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SharingLink
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SharingLink() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SharingLink createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SharingLink();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Identity getApplication() {
        return (Identity)this.backingStore.get("application");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("application", n -> this.setApplication((Identity)n.getObjectValue(Identity::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("preventsDownload", n -> this.setPreventsDownload(n.getBooleanValue()));
        deserializerMap.put("scope", n -> this.setScope(n.getStringValue()));
        deserializerMap.put("type", n -> this.setType(n.getStringValue()));
        deserializerMap.put("webHtml", n -> this.setWebHtml(n.getStringValue()));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getPreventsDownload() {
        return (Boolean)this.backingStore.get("preventsDownload");
    }

    @Nullable
    public String getScope() {
        return (String)this.backingStore.get("scope");
    }

    @Nullable
    public String getType() {
        return (String)this.backingStore.get("type");
    }

    @Nullable
    public String getWebHtml() {
        return (String)this.backingStore.get("webHtml");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("application", (Parsable)this.getApplication(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("preventsDownload", this.getPreventsDownload());
        writer.writeStringValue("scope", this.getScope());
        writer.writeStringValue("type", this.getType());
        writer.writeStringValue("webHtml", this.getWebHtml());
        writer.writeStringValue("webUrl", this.getWebUrl());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApplication(@Nullable Identity value) {
        this.backingStore.set("application", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPreventsDownload(@Nullable Boolean value) {
        this.backingStore.set("preventsDownload", (Object)value);
    }

    public void setScope(@Nullable String value) {
        this.backingStore.set("scope", (Object)value);
    }

    public void setType(@Nullable String value) {
        this.backingStore.set("type", (Object)value);
    }

    public void setWebHtml(@Nullable String value) {
        this.backingStore.set("webHtml", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

