/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.storage.filestorage.deletedcontainers.item;

import com.microsoft.graph.models.FileStorageContainer;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.activate.ActivateRequestBuilder;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.drive.DriveRequestBuilder;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.lock.LockRequestBuilder;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.permanentdelete.PermanentDeleteRequestBuilder;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.permissions.PermissionsRequestBuilder;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.recyclebin.RecycleBinRequestBuilder;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.restore.RestoreRequestBuilder;
import com.microsoft.graph.storage.filestorage.deletedcontainers.item.unlock.UnlockRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class FileStorageContainerItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ActivateRequestBuilder activate() {
        return new ActivateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DriveRequestBuilder drive() {
        return new DriveRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LockRequestBuilder lock() {
        return new LockRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PermanentDeleteRequestBuilder permanentDelete() {
        return new PermanentDeleteRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PermissionsRequestBuilder permissions() {
        return new PermissionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RecycleBinRequestBuilder recycleBin() {
        return new RecycleBinRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RestoreRequestBuilder restore() {
        return new RestoreRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public UnlockRequestBuilder unlock() {
        return new UnlockRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public FileStorageContainerItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/storage/fileStorage/deletedContainers/{fileStorageContainer%2Did}{?%24expand,%24select}", pathParameters);
    }

    public FileStorageContainerItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/storage/fileStorage/deletedContainers/{fileStorageContainer%2Did}{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public FileStorageContainer get() {
        return this.get(null);
    }

    @Nullable
    public FileStorageContainer get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (FileStorageContainer)this.requestAdapter.send(requestInfo, errorMapping, FileStorageContainer::createFromDiscriminatorValue);
    }

    @Nullable
    public FileStorageContainer patch(@Nonnull FileStorageContainer body) {
        return this.patch(body, null);
    }

    @Nullable
    public FileStorageContainer patch(@Nonnull FileStorageContainer body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (FileStorageContainer)this.requestAdapter.send(requestInfo, errorMapping, FileStorageContainer::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull FileStorageContainer body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull FileStorageContainer body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public FileStorageContainerItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new FileStorageContainerItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

