/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ClickSource;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserSimulationEventInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserSimulationEventInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserSimulationEventInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserSimulationEventInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getBrowser() {
        return (String)this.backingStore.get("browser");
    }

    @Nullable
    public ClickSource getClickSource() {
        return (ClickSource)((Object)this.backingStore.get("clickSource"));
    }

    @Nullable
    public OffsetDateTime getEventDateTime() {
        return (OffsetDateTime)this.backingStore.get("eventDateTime");
    }

    @Nullable
    public String getEventName() {
        return (String)this.backingStore.get("eventName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("browser", n -> this.setBrowser(n.getStringValue()));
        deserializerMap.put("clickSource", n -> this.setClickSource((ClickSource)n.getEnumValue(ClickSource::forValue)));
        deserializerMap.put("eventDateTime", n -> this.setEventDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("eventName", n -> this.setEventName(n.getStringValue()));
        deserializerMap.put("ipAddress", n -> this.setIpAddress(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("osPlatformDeviceDetails", n -> this.setOsPlatformDeviceDetails(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getIpAddress() {
        return (String)this.backingStore.get("ipAddress");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOsPlatformDeviceDetails() {
        return (String)this.backingStore.get("osPlatformDeviceDetails");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("browser", this.getBrowser());
        writer.writeEnumValue("clickSource", (Enum)this.getClickSource());
        writer.writeOffsetDateTimeValue("eventDateTime", this.getEventDateTime());
        writer.writeStringValue("eventName", this.getEventName());
        writer.writeStringValue("ipAddress", this.getIpAddress());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("osPlatformDeviceDetails", this.getOsPlatformDeviceDetails());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBrowser(@Nullable String value) {
        this.backingStore.set("browser", (Object)value);
    }

    public void setClickSource(@Nullable ClickSource value) {
        this.backingStore.set("clickSource", (Object)value);
    }

    public void setEventDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("eventDateTime", (Object)value);
    }

    public void setEventName(@Nullable String value) {
        this.backingStore.set("eventName", (Object)value);
    }

    public void setIpAddress(@Nullable String value) {
        this.backingStore.set("ipAddress", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOsPlatformDeviceDetails(@Nullable String value) {
        this.backingStore.set("osPlatformDeviceDetails", (Object)value);
    }
}

