/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ProtectionUnitBase;
import com.microsoft.graph.models.RestorePointTags;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RestorePoint
extends Entity
implements Parsable {
    @Nonnull
    public static RestorePoint createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new RestorePoint();
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("protectionDateTime", n -> this.setProtectionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("protectionUnit", n -> this.setProtectionUnit((ProtectionUnitBase)n.getObjectValue(ProtectionUnitBase::createFromDiscriminatorValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getEnumSetValue(RestorePointTags::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getProtectionDateTime() {
        return (OffsetDateTime)this.backingStore.get("protectionDateTime");
    }

    @Nullable
    public ProtectionUnitBase getProtectionUnit() {
        return (ProtectionUnitBase)this.backingStore.get("protectionUnit");
    }

    @Nullable
    public EnumSet<RestorePointTags> getTags() {
        return (EnumSet)this.backingStore.get("tags");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeOffsetDateTimeValue("protectionDateTime", this.getProtectionDateTime());
        writer.writeObjectValue("protectionUnit", (Parsable)this.getProtectionUnit(), new Parsable[0]);
        writer.writeEnumSetValue("tags", this.getTags());
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setProtectionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("protectionDateTime", (Object)value);
    }

    public void setProtectionUnit(@Nullable ProtectionUnitBase value) {
        this.backingStore.set("protectionUnit", (Object)value);
    }

    public void setTags(@Nullable EnumSet<RestorePointTags> value) {
        this.backingStore.set("tags", value);
    }
}

