/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ExchangeProtectionPolicy;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.OneDriveForBusinessProtectionPolicy;
import com.microsoft.graph.models.ProtectionPolicyStatus;
import com.microsoft.graph.models.RetentionSetting;
import com.microsoft.graph.models.SharePointProtectionPolicy;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProtectionPolicyBase
extends Entity
implements Parsable {
    @Nonnull
    public static ProtectionPolicyBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.exchangeProtectionPolicy": {
                    return new ExchangeProtectionPolicy();
                }
                case "#microsoft.graph.oneDriveForBusinessProtectionPolicy": {
                    return new OneDriveForBusinessProtectionPolicy();
                }
                case "#microsoft.graph.sharePointProtectionPolicy": {
                    return new SharePointProtectionPolicy();
                }
            }
        }
        return new ProtectionPolicyBase();
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("retentionSettings", n -> this.setRetentionSettings(n.getCollectionOfObjectValues(RetentionSetting::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((ProtectionPolicyStatus)n.getEnumValue(ProtectionPolicyStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<RetentionSetting> getRetentionSettings() {
        return (List)this.backingStore.get("retentionSettings");
    }

    @Nullable
    public ProtectionPolicyStatus getStatus() {
        return (ProtectionPolicyStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("retentionSettings", this.getRetentionSettings());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setRetentionSettings(@Nullable List<RetentionSetting> value) {
        this.backingStore.set("retentionSettings", value);
    }

    public void setStatus(@Nullable ProtectionPolicyStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

