/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AiInteractionAttachment;
import com.microsoft.graph.models.AiInteractionContext;
import com.microsoft.graph.models.AiInteractionLink;
import com.microsoft.graph.models.AiInteractionMention;
import com.microsoft.graph.models.AiInteractionType;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AiInteraction
extends Entity
implements Parsable {
    @Nonnull
    public static AiInteraction createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AiInteraction();
    }

    @Nullable
    public String getAppClass() {
        return (String)this.backingStore.get("appClass");
    }

    @Nullable
    public List<AiInteractionAttachment> getAttachments() {
        return (List)this.backingStore.get("attachments");
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public List<AiInteractionContext> getContexts() {
        return (List)this.backingStore.get("contexts");
    }

    @Nullable
    public String getConversationType() {
        return (String)this.backingStore.get("conversationType");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getEtag() {
        return (String)this.backingStore.get("etag");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appClass", n -> this.setAppClass(n.getStringValue()));
        deserializerMap.put("attachments", n -> this.setAttachments(n.getCollectionOfObjectValues(AiInteractionAttachment::createFromDiscriminatorValue)));
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("contexts", n -> this.setContexts(n.getCollectionOfObjectValues(AiInteractionContext::createFromDiscriminatorValue)));
        deserializerMap.put("conversationType", n -> this.setConversationType(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("etag", n -> this.setEtag(n.getStringValue()));
        deserializerMap.put("from", n -> this.setFrom((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("interactionType", n -> this.setInteractionType((AiInteractionType)n.getEnumValue(AiInteractionType::forValue)));
        deserializerMap.put("links", n -> this.setLinks(n.getCollectionOfObjectValues(AiInteractionLink::createFromDiscriminatorValue)));
        deserializerMap.put("locale", n -> this.setLocale(n.getStringValue()));
        deserializerMap.put("mentions", n -> this.setMentions(n.getCollectionOfObjectValues(AiInteractionMention::createFromDiscriminatorValue)));
        deserializerMap.put("requestId", n -> this.setRequestId(n.getStringValue()));
        deserializerMap.put("sessionId", n -> this.setSessionId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getFrom() {
        return (IdentitySet)this.backingStore.get("from");
    }

    @Nullable
    public AiInteractionType getInteractionType() {
        return (AiInteractionType)((Object)this.backingStore.get("interactionType"));
    }

    @Nullable
    public List<AiInteractionLink> getLinks() {
        return (List)this.backingStore.get("links");
    }

    @Nullable
    public String getLocale() {
        return (String)this.backingStore.get("locale");
    }

    @Nullable
    public List<AiInteractionMention> getMentions() {
        return (List)this.backingStore.get("mentions");
    }

    @Nullable
    public String getRequestId() {
        return (String)this.backingStore.get("requestId");
    }

    @Nullable
    public String getSessionId() {
        return (String)this.backingStore.get("sessionId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("appClass", this.getAppClass());
        writer.writeCollectionOfObjectValues("attachments", this.getAttachments());
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("contexts", this.getContexts());
        writer.writeStringValue("conversationType", this.getConversationType());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("etag", this.getEtag());
        writer.writeObjectValue("from", (Parsable)this.getFrom(), new Parsable[0]);
        writer.writeEnumValue("interactionType", (Enum)this.getInteractionType());
        writer.writeCollectionOfObjectValues("links", this.getLinks());
        writer.writeStringValue("locale", this.getLocale());
        writer.writeCollectionOfObjectValues("mentions", this.getMentions());
        writer.writeStringValue("requestId", this.getRequestId());
        writer.writeStringValue("sessionId", this.getSessionId());
    }

    public void setAppClass(@Nullable String value) {
        this.backingStore.set("appClass", (Object)value);
    }

    public void setAttachments(@Nullable List<AiInteractionAttachment> value) {
        this.backingStore.set("attachments", value);
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setContexts(@Nullable List<AiInteractionContext> value) {
        this.backingStore.set("contexts", value);
    }

    public void setConversationType(@Nullable String value) {
        this.backingStore.set("conversationType", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setEtag(@Nullable String value) {
        this.backingStore.set("etag", (Object)value);
    }

    public void setFrom(@Nullable IdentitySet value) {
        this.backingStore.set("from", (Object)value);
    }

    public void setInteractionType(@Nullable AiInteractionType value) {
        this.backingStore.set("interactionType", (Object)value);
    }

    public void setLinks(@Nullable List<AiInteractionLink> value) {
        this.backingStore.set("links", value);
    }

    public void setLocale(@Nullable String value) {
        this.backingStore.set("locale", (Object)value);
    }

    public void setMentions(@Nullable List<AiInteractionMention> value) {
        this.backingStore.set("mentions", value);
    }

    public void setRequestId(@Nullable String value) {
        this.backingStore.set("requestId", (Object)value);
    }

    public void setSessionId(@Nullable String value) {
        this.backingStore.set("sessionId", (Object)value);
    }
}

