/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class CoreConstants {
    private CoreConstants() {
    }

    public static class ReplacementConstants {
        public static final String USER_ID_TOKEN_TO_REPLACE = "TokenToReplace";
        public static final String USERS_ENDPOINT_WITH_REPLACE_TOKEN = "/users/TokenToReplace";
        public static final String ME_ENDPOINT = "/me";

        private ReplacementConstants() {
        }

        @Nonnull
        public static Map<String, String> getDefaultReplacementPairs() {
            HashMap<String, String> defaultReplacementPairs = new HashMap<String, String>();
            defaultReplacementPairs.put(USERS_ENDPOINT_WITH_REPLACE_TOKEN, ME_ENDPOINT);
            return defaultReplacementPairs;
        }
    }

    public static class CollectionResponseMethods {
        public static final String GET_ODATA_DELTA_LINK = "getOdataDeltaLink";
        public static final String GET_ODATA_NEXT_LINK = "getOdataNextLink";

        private CollectionResponseMethods() {
        }
    }

    public static class OdataInstanceAnnotations {
        public static final String NEXT_LINK = "@odata.nextLink";
        public static final String DELTA_LINK = "@odata.deltaLink";

        private OdataInstanceAnnotations() {
        }
    }

    public static class Serialization {
        public static final String ODATA_TYPE = "@odata.type";
        public static final String ODATA_NEXT_LINK = "@nextLink";

        private Serialization() {
        }
    }

    public static class MimeTypeNames {
        public static final String APPLICATION_JSON = "application/json";
        public static final String APPLICATION_STREAM = "application/octet-stream";

        private MimeTypeNames() {
        }
    }

    public static class BatchRequest {
        public static final int MAX_REQUESTS = 20;
        public static final String ID = "id";
        public static final String URL = "url";
        public static final String BODY = "body";
        public static final String DEPENDS_ON = "dependsOn";
        public static final String METHOD = "method";
        public static final String REQUESTS = "requests";
        public static final String RESPONSES = "responses";
        public static final String STATUS = "status";
        public static final String HEADERS = "headers";
        public static final String ERROR = "error";

        private BatchRequest() {
        }
    }

    public static class Headers {
        public static final String BEARER = "Bearer";
        public static final String SDK_VERSION_HEADER_NAME = "SdkVersion";
        public static final String GRAPH_VERSION_PREFIX = "graph-java-core";
        public static final String ANDROID_VERSION_PREFIX = "android";
        public static final String JAVA_VERSION_PREFIX = "java";
        public static final String VERSION = String.format(Locale.US, "%d.%d.%d", 3, 6, 5);
        public static final String CLIENT_REQUEST_ID = "client-request-id";
        public static final String FEATURE_FLAG = "FeatureFlag";
        public static final String DEFAULT_VERSION_VALUE = "0";

        private Headers() {
        }
    }

    private static class VersionValues {
        private static final int MAJOR = 3;
        private static final int MINOR = 6;
        private static final int PATCH = 5;

        private VersionValues() {
        }
    }
}

