/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests;

import com.microsoft.kiota.ApiException;
import com.microsoft.kiota.ApiExceptionBuilder;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.http.HeadersCompatibility;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ResponseBodyHandler<T extends Parsable>
implements ResponseHandler {
    private final ParseNodeFactory parseNodeFactory;
    private final ParsableFactory<T> factory;

    public ResponseBodyHandler(@Nullable ParseNodeFactory parseNodeFactory, @Nonnull ParsableFactory<T> factory) {
        this.parseNodeFactory = parseNodeFactory == null ? ParseNodeFactoryRegistry.defaultInstance : parseNodeFactory;
        this.factory = factory;
    }

    public ResponseBodyHandler(@Nonnull ParsableFactory<T> factory) {
        this(null, factory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <NativeResponseType, ModelType> ModelType handleResponse(@Nonnull NativeResponseType response, @Nullable HashMap<String, ParsableFactory<? extends Parsable>> errorMappings) {
        if (!(response instanceof Response)) throw new IllegalArgumentException("The provided response type is not supported by this response handler.");
        if (((Response)response).body() == null) throw new IllegalArgumentException("The provided response type is not supported by this response handler.");
        Response nativeResponse = (Response)response;
        ResponseBody body = nativeResponse.body();
        try (InputStream in = body.byteStream();){
            ParseNode parseNode = this.parseNodeFactory.getParseNode(body.contentType().type() + "/" + body.contentType().subtype(), in);
            body.close();
            if (nativeResponse.isSuccessful()) {
                Parsable result;
                Parsable parsable = result = parseNode.getObjectValue(this.factory);
                return (ModelType)parsable;
            }
            this.handleFailedResponse(nativeResponse, errorMappings, parseNode);
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void handleFailedResponse(Response nativeResponse, HashMap<String, ParsableFactory<? extends Parsable>> errorMappings, ParseNode parseNode) {
        Parsable result;
        int statusCode = nativeResponse.code();
        String statusCodeString = String.valueOf(statusCode);
        if (!(errorMappings != null && (errorMappings.containsKey(statusCodeString) || statusCode >= 400 && statusCode <= 499 && errorMappings.containsKey("4XX") || statusCode >= 500 && statusCode <= 599 && errorMappings.containsKey("5XX")))) {
            throw new ApiExceptionBuilder().withMessage("generalException").withResponseStatusCode(statusCode).withResponseHeaders(HeadersCompatibility.getResponseHeaders((Headers)nativeResponse.headers())).build();
        }
        String statusCodePattern = statusCodeString;
        if (!errorMappings.containsKey(statusCodePattern)) {
            if (statusCode >= 400 && statusCode <= 499 && errorMappings.containsKey("4XX")) {
                statusCodePattern = "4XX";
            } else if (statusCode >= 500 && statusCode <= 599 && errorMappings.containsKey("5XX")) {
                statusCodePattern = "5XX";
            }
        }
        if (!((result = parseNode.getObjectValue(errorMappings.get(statusCodePattern))) instanceof Exception)) {
            throw new ApiException("The server returned an unexpected status code and the error registered for this code failed to deserialize: " + statusCodeString);
        }
    }
}

