/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.common.base.CaseFormat;
import com.google.gson.JsonObject;
import com.microsoft.graph.logger.ILogger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DerivedClassIdentifier {
    private static final String ODATA_TYPE_KEY = "@odata.type";
    private final ILogger logger;

    public DerivedClassIdentifier(@Nonnull ILogger logger) {
        this.logger = Objects.requireNonNull(logger, "logger parameter cannot be null");
    }

    @Nullable
    public Class<?> identify(@Nonnull JsonObject jsonObject, @Nullable Class<?> parentClass) {
        Objects.requireNonNull(jsonObject, "parameter jsonObject cannot be null");
        if (jsonObject.get(ODATA_TYPE_KEY) != null) {
            String odataType = jsonObject.get(ODATA_TYPE_KEY).getAsString();
            int lastDotIndex = odataType.lastIndexOf(".");
            String derivedType = (odataType.substring(0, lastDotIndex) + ".models." + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, odataType.substring(lastDotIndex + 1))).replace("#", "com.");
            try {
                Class<?> derivedClass = Class.forName(derivedType);
                if (parentClass == null || parentClass.isAssignableFrom(derivedClass)) {
                    return derivedClass;
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                this.logger.logDebug("Unable to find a corresponding class for derived type " + derivedType + ". Falling back to parent class.");
                return null;
            }
        }
        return null;
    }
}

