/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.common.base.CaseFormat;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.http.GraphInnerError;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GraphError {
    @SerializedName(value="message")
    @Expose
    @Nullable
    public String message;
    @SerializedName(value="code")
    @Expose
    @Nullable
    public String code;
    @SerializedName(value="innererror")
    @Nullable
    public GraphInnerError innererror;

    public boolean isError(@Nonnull GraphErrorCodes expectedCode) {
        Objects.requireNonNull(expectedCode, "parameter expectedCode cannot be null");
        if (this.transformErrorCodeCase(this.code).equalsIgnoreCase(expectedCode.toString())) {
            return true;
        }
        GraphInnerError innerError = this.innererror;
        while (null != innerError) {
            if (this.transformErrorCodeCase(innerError.code).equalsIgnoreCase(expectedCode.toString())) {
                return true;
            }
            innerError = innerError.innererror;
        }
        return false;
    }

    @Nonnull
    protected String transformErrorCodeCase(@Nonnull String original) {
        Objects.requireNonNull(original, "parameter original cannot be null");
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, original);
    }
}

