package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.ValuedEnum;
import java.util.Objects;

/**
 * Malware threat status
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public enum WindowsMalwareThreatState implements ValuedEnum {
    /** Active */
    Active("active"),
    /** Action failed */
    ActionFailed("actionFailed"),
    /** Manual steps required */
    ManualStepsRequired("manualStepsRequired"),
    /** Full scan required */
    FullScanRequired("fullScanRequired"),
    /** Reboot required */
    RebootRequired("rebootRequired"),
    /** Remediated with non critical failures  */
    RemediatedWithNonCriticalFailures("remediatedWithNonCriticalFailures"),
    /** Quarantined */
    Quarantined("quarantined"),
    /** Removed */
    Removed("removed"),
    /** Cleaned */
    Cleaned("cleaned"),
    /** Allowed */
    Allowed("allowed"),
    /** No status cleared */
    NoStatusCleared("noStatusCleared");
    public final String value;
    WindowsMalwareThreatState(final String value) {
        this.value = value;
    }
    @jakarta.annotation.Nonnull
    public String getValue() { return this.value; }
    @jakarta.annotation.Nullable
    public static WindowsMalwareThreatState forValue(@jakarta.annotation.Nonnull final String searchValue) {
        Objects.requireNonNull(searchValue);
        switch(searchValue) {
            case "active": return Active;
            case "actionFailed": return ActionFailed;
            case "manualStepsRequired": return ManualStepsRequired;
            case "fullScanRequired": return FullScanRequired;
            case "rebootRequired": return RebootRequired;
            case "remediatedWithNonCriticalFailures": return RemediatedWithNonCriticalFailures;
            case "quarantined": return Quarantined;
            case "removed": return Removed;
            case "cleaned": return Cleaned;
            case "allowed": return Allowed;
            case "noStatusCleared": return NoStatusCleared;
            default: return null;
        }
    }
}
