package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.ValuedEnum;
import java.util.Objects;

/**
 * Malware current status
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public enum WindowsMalwareState implements ValuedEnum {
    /** Unknown */
    Unknown("unknown"),
    /** Detected */
    Detected("detected"),
    /** Cleaned */
    Cleaned("cleaned"),
    /** Quarantined */
    Quarantined("quarantined"),
    /** Removed */
    Removed("removed"),
    /** Allowed */
    Allowed("allowed"),
    /** Blocked */
    Blocked("blocked"),
    /** Clean failed */
    CleanFailed("cleanFailed"),
    /** Quarantine failed */
    QuarantineFailed("quarantineFailed"),
    /** Remove failed */
    RemoveFailed("removeFailed"),
    /** Allow failed */
    AllowFailed("allowFailed"),
    /** Abandoned */
    Abandoned("abandoned"),
    /** Block failed */
    BlockFailed("blockFailed");
    public final String value;
    WindowsMalwareState(final String value) {
        this.value = value;
    }
    @jakarta.annotation.Nonnull
    public String getValue() { return this.value; }
    @jakarta.annotation.Nullable
    public static WindowsMalwareState forValue(@jakarta.annotation.Nonnull final String searchValue) {
        Objects.requireNonNull(searchValue);
        switch(searchValue) {
            case "unknown": return Unknown;
            case "detected": return Detected;
            case "cleaned": return Cleaned;
            case "quarantined": return Quarantined;
            case "removed": return Removed;
            case "allowed": return Allowed;
            case "blocked": return Blocked;
            case "cleanFailed": return CleanFailed;
            case "quarantineFailed": return QuarantineFailed;
            case "removeFailed": return RemoveFailed;
            case "allowFailed": return AllowFailed;
            case "abandoned": return Abandoned;
            case "blockFailed": return BlockFailed;
            default: return null;
        }
    }
}
