/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.CancellationDetails;
import com.microsoft.cognitiveservices.speech.CancellationErrorCode;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.transcription.MeetingTranscriptionEventArgs;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class MeetingTranscriptionCanceledEventArgs
extends MeetingTranscriptionEventArgs {
    private String sessionId;
    private CancellationReason cancellationReason;
    private CancellationErrorCode errorCode;
    private String errorDetails;

    MeetingTranscriptionCanceledEventArgs(long l) {
        super(l);
        this.storeEventData(false);
    }

    MeetingTranscriptionCanceledEventArgs(long l, boolean bl) {
        super(l);
        this.storeEventData(bl);
    }

    public CancellationReason getReason() {
        return this.cancellationReason;
    }

    public CancellationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.sessionId + " ResultId:" + this.getResult().getResultId() + " CancellationReason:" + (Object)((Object)this.cancellationReason) + " CancellationErrorCode:" + (Object)((Object)this.errorCode) + " Error details:<" + this.errorDetails;
    }

    private void storeEventData(boolean bl) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        this.sessionId = this.getSessionId();
        Contracts.throwIfNull(this.sessionId, "SessionId");
        CancellationDetails cancellationDetails = CancellationDetails.fromResult(this.getResult());
        this.cancellationReason = cancellationDetails.getReason();
        this.errorCode = cancellationDetails.getErrorCode();
        this.errorDetails = cancellationDetails.getErrorDetails();
        if (bl) {
            super.close();
        }
    }
}

