/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.campaignmanagement.GenderTargetBid;
import com.microsoft.bingads.campaignmanagement.GenderType;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BulkGenderTargetBid
extends BulkTargetBid {
    private GenderTargetBid genderTargetBid;
    private static final List<BulkMapping<BulkGenderTargetBid>> MAPPINGS;

    BulkGenderTargetBid(BulkTargetIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setGenderTargetBid(new GenderTargetBid());
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getGenderTargetBid(), "GenderTargetBid");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public GenderTargetBid getGenderTargetBid() {
        return this.genderTargetBid;
    }

    public void setGenderTargetBid(GenderTargetBid genderTargetBid) {
        this.genderTargetBid = genderTargetBid;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkGenderTargetBid, Object>> m = new ArrayList<SimpleBulkMapping<BulkGenderTargetBid, Object>>();
        m.add(new SimpleBulkMapping<BulkGenderTargetBid, String>("Target", new Function<BulkGenderTargetBid, String>(){

            @Override
            public String apply(BulkGenderTargetBid c) {
                return c.getGenderTargetBid().getGender().value();
            }
        }, new BiConsumer<String, BulkGenderTargetBid>(){

            @Override
            public void accept(String v, BulkGenderTargetBid c) {
                c.getGenderTargetBid().setGender(GenderType.fromValue(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkGenderTargetBid, Integer>("Bid Adjustment", new Function<BulkGenderTargetBid, Integer>(){

            @Override
            public Integer apply(BulkGenderTargetBid c) {
                return c.getGenderTargetBid().getBidAdjustment();
            }
        }, new BiConsumer<String, BulkGenderTargetBid>(){

            @Override
            public void accept(String v, BulkGenderTargetBid c) {
                c.getGenderTargetBid().setBidAdjustment(Integer.parseInt(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

