/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QualityScoreData {
    private Integer qualityScore;
    private Integer keywordRelevance;
    private Integer landingPageRelevance;
    private Integer landingPageUserExperience;
    private static final List<BulkMapping<QualityScoreData>> MAPPINGS;

    public Integer getLandingPageUserExperience() {
        return this.landingPageUserExperience;
    }

    private void setLandingPageUserExperience(Integer landingPageUserExperience) {
        this.landingPageUserExperience = landingPageUserExperience;
    }

    public Integer getQualityScore() {
        return this.qualityScore;
    }

    private void setQualityScore(Integer qualityScore) {
        this.qualityScore = qualityScore;
    }

    public Integer getKeywordRelevance() {
        return this.keywordRelevance;
    }

    private void setKeywordRelevance(Integer keywordRelevance) {
        this.keywordRelevance = keywordRelevance;
    }

    public Integer getLandingPageRelevance() {
        return this.landingPageRelevance;
    }

    private void setLandingPageRelevance(Integer landingPageRelevance) {
        this.landingPageRelevance = landingPageRelevance;
    }

    public static QualityScoreData readFromRowValuesOrNull(RowValues values) {
        QualityScoreData qualityScoreData = new QualityScoreData();
        qualityScoreData.readFromRowValues(values);
        return qualityScoreData.hasAnyValues() ? qualityScoreData : null;
    }

    private boolean hasAnyValues() {
        return this.qualityScore != null || this.keywordRelevance != null || this.landingPageRelevance != null || this.landingPageUserExperience != null;
    }

    public void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    static {
        ArrayList m = new ArrayList();
        m.add(new SimpleBulkMapping("Quality Score", new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setQualityScore(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping("Keyword Relevance", new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setKeywordRelevance(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping("Landing Page Relevance", new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setLandingPageRelevance(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping("Landing Page User Experience", new BiConsumer<String, QualityScoreData>(){

            @Override
            public void accept(String v, QualityScoreData d) {
                d.setLandingPageUserExperience(StringExtensions.parseOptionalInteger(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

