/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.bulk.entities.SingleRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class BulkAccount
extends SingleRecordBulkEntity {
    private long id;
    private long customerId;
    private Calendar syncTime;
    private static final List<BulkMapping<BulkAccount>> MAPPINGS;

    public long getId() {
        return this.id;
    }

    private void setId(long id) {
        this.id = id;
    }

    public long getCustomerId() {
        return this.customerId;
    }

    private void setCustomerId(long customerId) {
        this.customerId = customerId;
    }

    public Calendar getSyncTime() {
        return this.syncTime;
    }

    private void setSyncTime(Calendar syncTime) {
        this.syncTime = syncTime;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values) {
        throw new UnsupportedOperationException();
    }

    static {
        ArrayList m = new ArrayList();
        m.add(new SimpleBulkMapping("Id", new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping("Parent Id", new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setCustomerId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping("Sync Time", new BiConsumer<String, BulkAccount>(){

            @Override
            public void accept(String v, BulkAccount c) {
                c.setSyncTime(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

