/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.adintelligence.IAdIntelligenceService;
import com.microsoft.bingads.bulk.IBulkService;
import com.microsoft.bingads.campaignmanagement.ICampaignManagementService;
import com.microsoft.bingads.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.customermanagement.ICustomerManagementService;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceInfo;
import com.microsoft.bingads.optimizer.IOptimizerService;
import com.microsoft.bingads.reporting.IReportingService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.message.Message;

class ServiceFactoryImpl
implements ServiceFactory {
    private static final String VERSION = "9.3.0";
    private static final Map<Class, ServiceInfo> endpoints = new HashMap<Class, ServiceInfo>(){
        {
            this.put(IAdIntelligenceService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://api.bingads.microsoft.com/Api/Advertiser/AdIntelligence/v9/AdIntelligenceService.svc");
                    this.setSandboxUrl("https://api.sandbox.bingads.microsoft.com/Api/Advertiser/AdIntelligence/v9/AdIntelligenceService.svc");
                }
            });
            this.put(IBulkService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v9/BulkService.svc");
                    this.setSandboxUrl("https://api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v9/BulkService.svc");
                }
            });
            this.put(ICampaignManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v9/CampaignManagementService.svc");
                    this.setSandboxUrl("https://api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v9/CampaignManagementService.svc");
                }
            });
            this.put(ICustomerBillingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/Billing/v9/CustomerBillingService.svc");
                }
            });
            this.put(ICustomerManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/CustomerManagement/v9/CustomerManagementService.svc");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/Api/CustomerManagement/v9/CustomerManagementService.svc");
                }
            });
            this.put(IOptimizerService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://api.bingads.microsoft.com/Api/Advertiser/Optimizer/v9/OptimizerService.svc");
                    this.setSandboxUrl("https://api.sandbox.bingads.microsoft.com/Api/Advertiser/Optimizer/v9/OptimizerService.svc");
                }
            });
            this.put(IReportingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://api.bingads.microsoft.com/Api/Advertiser/Reporting/v9/ReportingService.svc");
                    this.setSandboxUrl("https://api.sandbox.bingads.microsoft.com/Api/Advertiser/Reporting/v9/ReportingService.svc");
                }
            });
        }
    };

    ServiceFactoryImpl() {
    }

    @Override
    public Service createService(Class serviceInterface) {
        QName qName = this.getServiceQname(serviceInterface);
        return Service.create((QName)qName);
    }

    private String getServiceUrl(Class serviceInterface, ApiEnvironment env) {
        String serviceUrl = this.getServiceUrlFromConfig(serviceInterface);
        if (serviceUrl == null) {
            ServiceInfo serviceInfo = endpoints.get(serviceInterface);
            serviceUrl = serviceInfo.GetUrl(env);
        }
        return serviceUrl;
    }

    private QName getServiceQname(Class serviceInterface) {
        WebService webServiceAnnotation = serviceInterface.getAnnotation(WebService.class);
        String serviceName = webServiceAnnotation.name();
        if (serviceName.startsWith("I")) {
            serviceName = serviceName.substring(1);
        }
        QName qName = new QName(webServiceAnnotation.targetNamespace(), serviceName);
        return qName;
    }

    @Override
    public <T> T createProxyFromService(Service service, ApiEnvironment env, Class<T> serviceInterface) {
        Object port = service.getPort(serviceInterface);
        String serviceUrl = this.getServiceUrl(serviceInterface, env);
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", serviceUrl);
        this.addUserAgent(port);
        return (T)port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceUrlFromConfig(Class serviceInterface) {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream("bingads.properties");
            if (input == null) {
                String string = null;
                return string;
            }
            Properties props = new Properties();
            props.load(input);
            String string = props.getProperty(serviceInterface.getCanonicalName() + ".url");
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ServiceFactoryImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private <T> void addUserAgent(T port) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("User-Agent", Arrays.asList("BingAdsSDKJava 9.3.0"));
        ((Client)port).getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
    }
}

