/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.BidStrategy;
import com.microsoft.bingads.v13.campaignmanagement.BiddingScheme;
import com.microsoft.bingads.v13.campaignmanagement.CampaignType;
import com.microsoft.bingads.v13.campaignmanagement.EntityScope;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BulkBidStrategy
extends SingleRecordBulkEntity {
    private BidStrategy bidStrategy;
    private Long accountId;
    private Status status;
    private static final List<BulkMapping<BulkBidStrategy>> MAPPINGS;

    public BidStrategy getBidStrategy() {
        return this.bidStrategy;
    }

    public void setBidStrategy(BidStrategy bidStrategy) {
        this.bidStrategy = bidStrategy;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setBidStrategy(new BidStrategy());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBidStrategy(), "BidStrategy");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkBidStrategy, Long>("Id", new Function<BulkBidStrategy, Long>(){

            @Override
            public Long apply(BulkBidStrategy t) {
                return t.getBidStrategy().getId();
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(String v, BulkBidStrategy c) {
                c.getBidStrategy().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBidStrategy, Long>("Parent Id", new Function<BulkBidStrategy, Long>(){

            @Override
            public Long apply(BulkBidStrategy c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(String v, BulkBidStrategy c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBidStrategy, String>("Status", new Function<BulkBidStrategy, String>(){

            @Override
            public String apply(BulkBidStrategy t) {
                return t.getStatus() != null ? t.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(String v, BulkBidStrategy c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBidStrategy, String>("Bid Strategy Name", new Function<BulkBidStrategy, String>(){

            @Override
            public String apply(BulkBidStrategy t) {
                return t.getBidStrategy().getName();
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(String v, BulkBidStrategy c) {
                c.getBidStrategy().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkBidStrategy, String>("Campaign Type", new Function<BulkBidStrategy, String>(){

            @Override
            public String apply(BulkBidStrategy c) {
                if (c.getBidStrategy().getAssociatedCampaignType() == null) {
                    return null;
                }
                if (c.getBidStrategy().getAssociatedCampaignType().size() != 1) {
                    throw new IllegalArgumentException("Only 1 CampaignType can be set in Campaign");
                }
                Collection<CampaignType> campaignTypes = c.getBidStrategy().getAssociatedCampaignType();
                return campaignTypes.toArray(new CampaignType[campaignTypes.size()])[0].value();
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(final String v, BulkBidStrategy c) {
                c.getBidStrategy().setAssociatedCampaignType(StringExtensions.parseOptional(v, new Function<String, Collection<CampaignType>>(){

                    @Override
                    public Collection<CampaignType> apply(String value) {
                        return Collections.singletonList(StringExtensions.fromValueOptional(v, CampaignType.class));
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBidStrategy, String>("Bid Strategy Scope", new Function<BulkBidStrategy, String>(){

            @Override
            public String apply(BulkBidStrategy c) {
                return c.getBidStrategy().getScope() != null ? c.getBidStrategy().getScope().value() : null;
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(String v, BulkBidStrategy c) {
                c.getBidStrategy().setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return StringExtensions.fromValueOptional(value, EntityScope.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBidStrategy, String>("Currency Code", new Function<BulkBidStrategy, String>(){

            @Override
            public String apply(BulkBidStrategy c) {
                return c.getBidStrategy().getCurrencyCode();
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(String v, BulkBidStrategy c) {
                c.getBidStrategy().setCurrencyCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkBidStrategy, String>("Time Zone", new Function<BulkBidStrategy, String>(){

            @Override
            public String apply(BulkBidStrategy c) {
                return c.getBidStrategy().getReportingTimeZone();
            }
        }, new BiConsumer<String, BulkBidStrategy>(){

            @Override
            public void accept(String v, BulkBidStrategy c) {
                c.getBidStrategy().setReportingTimeZone(v);
            }
        }));
        m.add(new ComplexBulkMapping<BulkBidStrategy>(new BiConsumer<BulkBidStrategy, RowValues>(){

            @Override
            public void accept(BulkBidStrategy c, RowValues values) {
                StringExtensions.writeBiddingScheme(c.getBidStrategy().getBiddingScheme(), c.getBidStrategy().getId(), values);
            }
        }, new BiConsumer<RowValues, BulkBidStrategy>(){

            @Override
            public void accept(RowValues values, BulkBidStrategy c) {
                BiddingScheme biddingScheme = StringExtensions.readBiddingScheme(values);
                if (biddingScheme != null) {
                    c.getBidStrategy().setBiddingScheme(biddingScheme);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

