/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.AssetGroup;
import com.microsoft.bingads.v13.campaignmanagement.AssetGroupEditorialStatus;
import com.microsoft.bingads.v13.campaignmanagement.AssetGroupStatus;
import com.microsoft.bingads.v13.campaignmanagement.CallToAction;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAssetGroup
extends SingleRecordBulkEntity {
    private Long campaignId;
    private String campaignName;
    private AssetGroup assetGroup;
    private static final List<BulkMapping<BulkAssetGroup>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAssetGroup(new AssetGroup());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAssetGroup(), "AssetGroup");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public Long getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public AssetGroup getAssetGroup() {
        return this.assetGroup;
    }

    public void setAssetGroup(AssetGroup assetGroup) {
        this.assetGroup = assetGroup;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAssetGroup, Object>> m = new ArrayList<SimpleBulkMapping<BulkAssetGroup, Object>>();
        m.add(new SimpleBulkMapping<BulkAssetGroup, Long>("Id", new Function<BulkAssetGroup, Long>(){

            @Override
            public Long apply(BulkAssetGroup c) {
                return c.getAssetGroup().getId();
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Status", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return c.getAssetGroup().getStatus() != null ? c.getAssetGroup().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setStatus(StringExtensions.parseOptional(v, new Function<String, AssetGroupStatus>(){

                    @Override
                    public AssetGroupStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, AssetGroupStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, Long>("Parent Id", new Function<BulkAssetGroup, Long>(){

            @Override
            public Long apply(BulkAssetGroup c) {
                return c.getCampaignId();
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Campaign", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Asset Group", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return c.getAssetGroup().getName();
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Start Date", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toDateBulkString(c.getAssetGroup().getStartDate());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                try {
                    c.getAssetGroup().setStartDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("End Date", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toDateBulkString(c.getAssetGroup().getEndDate());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                try {
                    c.getAssetGroup().setEndDate(StringExtensions.parseDate(v));
                }
                catch (ParseException ex) {
                    throw new UncheckedParseException(ex);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Business Name", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return c.getAssetGroup().getBusinessName();
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setBusinessName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Call To Action", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return c.getAssetGroup().getCallToAction() != null ? c.getAssetGroup().getCallToAction().value() : null;
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setCallToAction(StringExtensions.parseOptional(v, new Function<String, CallToAction>(){

                    @Override
                    public CallToAction apply(String value) {
                        return StringExtensions.fromValueOptional(value, CallToAction.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Descriptions", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toTextAssetLinksBulkString(c.getAssetGroup().getDescriptions());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setDescriptions(StringExtensions.parseTextAssetLinks(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Editorial Status", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup t) {
                return t.getAssetGroup().getEditorialStatus() != null ? t.getAssetGroup().getEditorialStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setEditorialStatus(StringExtensions.parseOptional(v, new Function<String, AssetGroupEditorialStatus>(){

                    @Override
                    public AssetGroupEditorialStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, AssetGroupEditorialStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Mobile Final Url", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.writeUrls("; ", c.getAssetGroup().getFinalMobileUrls(), c.getAssetGroup().getId());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getAssetGroup().setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Final Url", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.writeUrls("; ", c.getAssetGroup().getFinalUrls(), c.getAssetGroup().getId());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getAssetGroup().setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Headlines", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toTextAssetLinksBulkString(c.getAssetGroup().getHeadlines());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setHeadlines(StringExtensions.parseTextAssetLinks(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Images", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toImageAssetLinksBulkString(c.getAssetGroup().getImages());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setImages(StringExtensions.parseImageAssetLinks(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Long Headlines", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toTextAssetLinksBulkString(c.getAssetGroup().getLongHeadlines());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setLongHeadlines(StringExtensions.parseTextAssetLinks(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Path 1", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAssetGroup().getPath1(), c.getAssetGroup().getId());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setPath1(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Path 2", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAssetGroup().getPath2(), c.getAssetGroup().getId());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setPath2(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Tracking Template", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAssetGroup().getTrackingUrlTemplate(), c.getAssetGroup().getId());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Final Url Suffix", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toOptionalBulkString(c.getAssetGroup().getFinalUrlSuffix(), c.getAssetGroup().getId());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                c.getAssetGroup().setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkAssetGroup, String>("Custom Parameter", new Function<BulkAssetGroup, String>(){

            @Override
            public String apply(BulkAssetGroup c) {
                return StringExtensions.toCustomParaBulkString(c.getAssetGroup().getUrlCustomParameters(), c.getAssetGroup().getId());
            }
        }, new BiConsumer<String, BulkAssetGroup>(){

            @Override
            public void accept(String v, BulkAssetGroup c) {
                try {
                    c.getAssetGroup().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

