/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.TopicCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupTopicCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupTopicCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new TopicCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupTopicCriterion, Long>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupTopicCriterion, Long>>();
        m.add(new SimpleBulkMapping<BulkAdGroupTopicCriterion, Long>("Target", new Function<BulkAdGroupTopicCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupTopicCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof TopicCriterion) {
                    return ((TopicCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getTopicId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupTopicCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupTopicCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof TopicCriterion) {
                    ((TopicCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setTopicId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                        @Override
                        public Long apply(String s) {
                            return Long.parseLong(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

