/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.restful.ResponseInfo;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import com.microsoft.bingads.v13.customerbilling.AdApiFaultDetail;
import com.microsoft.bingads.v13.customerbilling.AdApiFaultDetail_Exception;
import com.microsoft.bingads.v13.customerbilling.AddInsertionOrderRequest;
import com.microsoft.bingads.v13.customerbilling.AddInsertionOrderResponse;
import com.microsoft.bingads.v13.customerbilling.ApiBatchFault;
import com.microsoft.bingads.v13.customerbilling.ApiBatchFault_Exception;
import com.microsoft.bingads.v13.customerbilling.ApiFault;
import com.microsoft.bingads.v13.customerbilling.ApiFault_Exception;
import com.microsoft.bingads.v13.customerbilling.ApplicationFault;
import com.microsoft.bingads.v13.customerbilling.CheckFeatureAdoptionCouponEligibilityRequest;
import com.microsoft.bingads.v13.customerbilling.CheckFeatureAdoptionCouponEligibilityResponse;
import com.microsoft.bingads.v13.customerbilling.ClaimFeatureAdoptionCouponsRequest;
import com.microsoft.bingads.v13.customerbilling.ClaimFeatureAdoptionCouponsResponse;
import com.microsoft.bingads.v13.customerbilling.DispatchCouponsRequest;
import com.microsoft.bingads.v13.customerbilling.DispatchCouponsResponse;
import com.microsoft.bingads.v13.customerbilling.DistributeCouponsRequest;
import com.microsoft.bingads.v13.customerbilling.DistributeCouponsResponse;
import com.microsoft.bingads.v13.customerbilling.GetAccountMonthlySpendRequest;
import com.microsoft.bingads.v13.customerbilling.GetAccountMonthlySpendResponse;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsInfoRequest;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsInfoResponse;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsRequest;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsResponse;
import com.microsoft.bingads.v13.customerbilling.GetCouponInfoRequest;
import com.microsoft.bingads.v13.customerbilling.GetCouponInfoResponse;
import com.microsoft.bingads.v13.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.v13.customerbilling.RedeemCouponRequest;
import com.microsoft.bingads.v13.customerbilling.RedeemCouponResponse;
import com.microsoft.bingads.v13.customerbilling.SearchCouponsRequest;
import com.microsoft.bingads.v13.customerbilling.SearchCouponsResponse;
import com.microsoft.bingads.v13.customerbilling.SearchInsertionOrdersRequest;
import com.microsoft.bingads.v13.customerbilling.SearchInsertionOrdersResponse;
import com.microsoft.bingads.v13.customerbilling.UpdateInsertionOrderRequest;
import com.microsoft.bingads.v13.customerbilling.UpdateInsertionOrderResponse;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.util.Map;
import java.util.concurrent.Future;

public class CustomerBillingService
extends RestfulServiceClient
implements ICustomerBillingService {
    public CustomerBillingService(Map<String, String> headers, ApiEnvironment env) {
        super(headers, env, ICustomerBillingService.class);
    }

    Exception processFaultDetail(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFault) {
            ApiFault_Exception ex = new ApiFault_Exception(message, (ApiFault)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    Exception processFaultDetailApiBatchFault(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiBatchFault) {
            ApiBatchFault_Exception ex = new ApiBatchFault_Exception(message, (ApiBatchFault)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFault) {
            ApiFault_Exception ex = new ApiFault_Exception(message, (ApiFault)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    protected <Req, Resp> Resp sendRequest(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetail(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    protected <Req, Resp> Resp sendRequestApiBatchFault(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetailApiBatchFault(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    private Exception getFaultException(ApplicationFault faultDetail) {
        try {
            Exception ex = this.processFaultDetail(faultDetail, false);
            if (ex == null) {
                ex = this.processFaultDetailApiBatchFault(faultDetail, false);
            }
            return ex;
        }
        catch (Exception ex) {
            throw new InternalException(ex);
        }
    }

    protected <Req, Resp> Response<Resp> sendRequestAsync(Req request, String entityEndpoint, String verb, Class<Resp> respClass, AsyncHandler<Resp> handler) {
        return this.processRequestAsync(request, entityEndpoint, verb, respClass, ApplicationFault.class, x -> this.getFaultException((ApplicationFault)x), handler);
    }

    @Override
    public GetBillingDocumentsInfoResponse getBillingDocumentsInfo(GetBillingDocumentsInfoRequest request) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        GetBillingDocumentsInfoResponse response = this.sendRequestApiBatchFault(request, "/BillingDocumentsInfo/Query", "POST", GetBillingDocumentsInfoResponse.class);
        return response;
    }

    @Override
    public Response<GetBillingDocumentsInfoResponse> getBillingDocumentsInfoAsync(GetBillingDocumentsInfoRequest request) {
        return this.sendRequestAsync(request, "/BillingDocumentsInfo/Query", "POST", GetBillingDocumentsInfoResponse.class, null);
    }

    @Override
    public Future<?> getBillingDocumentsInfoAsync(GetBillingDocumentsInfoRequest request, AsyncHandler<GetBillingDocumentsInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BillingDocumentsInfo/Query", "POST", GetBillingDocumentsInfoResponse.class, asyncHandler);
    }

    @Override
    public GetBillingDocumentsResponse getBillingDocuments(GetBillingDocumentsRequest request) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        GetBillingDocumentsResponse response = this.sendRequestApiBatchFault(request, "/BillingDocuments/Query", "POST", GetBillingDocumentsResponse.class);
        return response;
    }

    @Override
    public Response<GetBillingDocumentsResponse> getBillingDocumentsAsync(GetBillingDocumentsRequest request) {
        return this.sendRequestAsync(request, "/BillingDocuments/Query", "POST", GetBillingDocumentsResponse.class, null);
    }

    @Override
    public Future<?> getBillingDocumentsAsync(GetBillingDocumentsRequest request, AsyncHandler<GetBillingDocumentsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BillingDocuments/Query", "POST", GetBillingDocumentsResponse.class, asyncHandler);
    }

    @Override
    public AddInsertionOrderResponse addInsertionOrder(AddInsertionOrderRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        AddInsertionOrderResponse response = this.sendRequest(request, "/InsertionOrder", "POST", AddInsertionOrderResponse.class);
        return response;
    }

    @Override
    public Response<AddInsertionOrderResponse> addInsertionOrderAsync(AddInsertionOrderRequest request) {
        return this.sendRequestAsync(request, "/InsertionOrder", "POST", AddInsertionOrderResponse.class, null);
    }

    @Override
    public Future<?> addInsertionOrderAsync(AddInsertionOrderRequest request, AsyncHandler<AddInsertionOrderResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/InsertionOrder", "POST", AddInsertionOrderResponse.class, asyncHandler);
    }

    @Override
    public UpdateInsertionOrderResponse updateInsertionOrder(UpdateInsertionOrderRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdateInsertionOrderResponse response = this.sendRequest(request, "/InsertionOrder", "PUT", UpdateInsertionOrderResponse.class);
        return response;
    }

    @Override
    public Response<UpdateInsertionOrderResponse> updateInsertionOrderAsync(UpdateInsertionOrderRequest request) {
        return this.sendRequestAsync(request, "/InsertionOrder", "PUT", UpdateInsertionOrderResponse.class, null);
    }

    @Override
    public Future<?> updateInsertionOrderAsync(UpdateInsertionOrderRequest request, AsyncHandler<UpdateInsertionOrderResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/InsertionOrder", "PUT", UpdateInsertionOrderResponse.class, asyncHandler);
    }

    @Override
    public SearchInsertionOrdersResponse searchInsertionOrders(SearchInsertionOrdersRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchInsertionOrdersResponse response = this.sendRequest(request, "/InsertionOrders/Search", "POST", SearchInsertionOrdersResponse.class);
        return response;
    }

    @Override
    public Response<SearchInsertionOrdersResponse> searchInsertionOrdersAsync(SearchInsertionOrdersRequest request) {
        return this.sendRequestAsync(request, "/InsertionOrders/Search", "POST", SearchInsertionOrdersResponse.class, null);
    }

    @Override
    public Future<?> searchInsertionOrdersAsync(SearchInsertionOrdersRequest request, AsyncHandler<SearchInsertionOrdersResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/InsertionOrders/Search", "POST", SearchInsertionOrdersResponse.class, asyncHandler);
    }

    @Override
    public GetAccountMonthlySpendResponse getAccountMonthlySpend(GetAccountMonthlySpendRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetAccountMonthlySpendResponse response = this.sendRequest(request, "/AccountMonthlySpend/Query", "POST", GetAccountMonthlySpendResponse.class);
        return response;
    }

    @Override
    public Response<GetAccountMonthlySpendResponse> getAccountMonthlySpendAsync(GetAccountMonthlySpendRequest request) {
        return this.sendRequestAsync(request, "/AccountMonthlySpend/Query", "POST", GetAccountMonthlySpendResponse.class, null);
    }

    @Override
    public Future<?> getAccountMonthlySpendAsync(GetAccountMonthlySpendRequest request, AsyncHandler<GetAccountMonthlySpendResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AccountMonthlySpend/Query", "POST", GetAccountMonthlySpendResponse.class, asyncHandler);
    }

    @Override
    public DispatchCouponsResponse dispatchCoupons(DispatchCouponsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        DispatchCouponsResponse response = this.sendRequest(request, "/Coupons/Dispatch", "POST", DispatchCouponsResponse.class);
        return response;
    }

    @Override
    public Response<DispatchCouponsResponse> dispatchCouponsAsync(DispatchCouponsRequest request) {
        return this.sendRequestAsync(request, "/Coupons/Dispatch", "POST", DispatchCouponsResponse.class, null);
    }

    @Override
    public Future<?> dispatchCouponsAsync(DispatchCouponsRequest request, AsyncHandler<DispatchCouponsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Coupons/Dispatch", "POST", DispatchCouponsResponse.class, asyncHandler);
    }

    @Override
    public RedeemCouponResponse redeemCoupon(RedeemCouponRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        RedeemCouponResponse response = this.sendRequest(request, "/Coupon/Redeem", "POST", RedeemCouponResponse.class);
        return response;
    }

    @Override
    public Response<RedeemCouponResponse> redeemCouponAsync(RedeemCouponRequest request) {
        return this.sendRequestAsync(request, "/Coupon/Redeem", "POST", RedeemCouponResponse.class, null);
    }

    @Override
    public Future<?> redeemCouponAsync(RedeemCouponRequest request, AsyncHandler<RedeemCouponResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Coupon/Redeem", "POST", RedeemCouponResponse.class, asyncHandler);
    }

    @Override
    public SearchCouponsResponse searchCoupons(SearchCouponsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchCouponsResponse response = this.sendRequest(request, "/Coupons/Search", "POST", SearchCouponsResponse.class);
        return response;
    }

    @Override
    public Response<SearchCouponsResponse> searchCouponsAsync(SearchCouponsRequest request) {
        return this.sendRequestAsync(request, "/Coupons/Search", "POST", SearchCouponsResponse.class, null);
    }

    @Override
    public Future<?> searchCouponsAsync(SearchCouponsRequest request, AsyncHandler<SearchCouponsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Coupons/Search", "POST", SearchCouponsResponse.class, asyncHandler);
    }

    @Override
    public CheckFeatureAdoptionCouponEligibilityResponse checkFeatureAdoptionCouponEligibility(CheckFeatureAdoptionCouponEligibilityRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        CheckFeatureAdoptionCouponEligibilityResponse response = this.sendRequest(request, "/FeatureAdoptionCouponEligibility/Check", "POST", CheckFeatureAdoptionCouponEligibilityResponse.class);
        return response;
    }

    @Override
    public Response<CheckFeatureAdoptionCouponEligibilityResponse> checkFeatureAdoptionCouponEligibilityAsync(CheckFeatureAdoptionCouponEligibilityRequest request) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCouponEligibility/Check", "POST", CheckFeatureAdoptionCouponEligibilityResponse.class, null);
    }

    @Override
    public Future<?> checkFeatureAdoptionCouponEligibilityAsync(CheckFeatureAdoptionCouponEligibilityRequest request, AsyncHandler<CheckFeatureAdoptionCouponEligibilityResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCouponEligibility/Check", "POST", CheckFeatureAdoptionCouponEligibilityResponse.class, asyncHandler);
    }

    @Override
    public ClaimFeatureAdoptionCouponsResponse claimFeatureAdoptionCoupons(ClaimFeatureAdoptionCouponsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        ClaimFeatureAdoptionCouponsResponse response = this.sendRequest(request, "/FeatureAdoptionCoupons/Claim", "POST", ClaimFeatureAdoptionCouponsResponse.class);
        return response;
    }

    @Override
    public Response<ClaimFeatureAdoptionCouponsResponse> claimFeatureAdoptionCouponsAsync(ClaimFeatureAdoptionCouponsRequest request) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCoupons/Claim", "POST", ClaimFeatureAdoptionCouponsResponse.class, null);
    }

    @Override
    public Future<?> claimFeatureAdoptionCouponsAsync(ClaimFeatureAdoptionCouponsRequest request, AsyncHandler<ClaimFeatureAdoptionCouponsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCoupons/Claim", "POST", ClaimFeatureAdoptionCouponsResponse.class, asyncHandler);
    }

    @Override
    public GetCouponInfoResponse getCouponInfo(GetCouponInfoRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetCouponInfoResponse response = this.sendRequest(request, "/CouponInfo/Query", "POST", GetCouponInfoResponse.class);
        return response;
    }

    @Override
    public Response<GetCouponInfoResponse> getCouponInfoAsync(GetCouponInfoRequest request) {
        return this.sendRequestAsync(request, "/CouponInfo/Query", "POST", GetCouponInfoResponse.class, null);
    }

    @Override
    public Future<?> getCouponInfoAsync(GetCouponInfoRequest request, AsyncHandler<GetCouponInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/CouponInfo/Query", "POST", GetCouponInfoResponse.class, asyncHandler);
    }

    @Override
    public DistributeCouponsResponse distributeCoupons(DistributeCouponsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        DistributeCouponsResponse response = this.sendRequest(request, "/Coupons/Distribute", "POST", DistributeCouponsResponse.class);
        return response;
    }

    @Override
    public Response<DistributeCouponsResponse> distributeCouponsAsync(DistributeCouponsRequest request) {
        return this.sendRequestAsync(request, "/Coupons/Distribute", "POST", DistributeCouponsResponse.class, null);
    }

    @Override
    public Future<?> distributeCouponsAsync(DistributeCouponsRequest request, AsyncHandler<DistributeCouponsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Coupons/Distribute", "POST", DistributeCouponsResponse.class, asyncHandler);
    }
}

