/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.QualityScoreData;
import com.microsoft.bingads.v13.campaignmanagement.AppSetting;
import com.microsoft.bingads.v13.campaignmanagement.AppStore;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfSetting;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfTargetSettingDetail;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOflong;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.BiddingScheme;
import com.microsoft.bingads.v13.campaignmanagement.BudgetLimitType;
import com.microsoft.bingads.v13.campaignmanagement.Campaign;
import com.microsoft.bingads.v13.campaignmanagement.CampaignStatus;
import com.microsoft.bingads.v13.campaignmanagement.CampaignType;
import com.microsoft.bingads.v13.campaignmanagement.DisclaimerSetting;
import com.microsoft.bingads.v13.campaignmanagement.DynamicFeedSetting;
import com.microsoft.bingads.v13.campaignmanagement.DynamicSearchAdsSetting;
import com.microsoft.bingads.v13.campaignmanagement.DynamicSearchAdsSource;
import com.microsoft.bingads.v13.campaignmanagement.NewCustomerAcquisitionGoalSetting;
import com.microsoft.bingads.v13.campaignmanagement.PerformanceMaxSetting;
import com.microsoft.bingads.v13.campaignmanagement.Setting;
import com.microsoft.bingads.v13.campaignmanagement.ShoppingSetting;
import com.microsoft.bingads.v13.campaignmanagement.TargetSetting;
import com.microsoft.bingads.v13.campaignmanagement.TargetSettingDetail;
import com.microsoft.bingads.v13.campaignmanagement.VerifiedTrackingSetting;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.ComplexBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class BulkCampaign
extends SingleRecordBulkEntity {
    private Long accountId;
    private Campaign campaign;
    private QualityScoreData qualityScoreData;
    private String budgetName;
    private String BidStrategyName;
    private String DestinationChannel;
    private Boolean IsMultiChannelCampaign;
    private Boolean ShouldServeOnMSAN;
    private static final List<BulkMapping<BulkCampaign>> MAPPINGS;
    private static BiConsumer<BulkCampaign, RowValues> budgetToCsv;
    private static BiConsumer<RowValues, BulkCampaign> csvToBudget;

    private Setting getCampaignSetting(Class<? extends Setting> settingClass, boolean addIfNotExist) {
        if (this.campaign.getSettings() == null && addIfNotExist) {
            this.tryAddCampaignSettings();
        }
        if (this.getCampaign().getSettings() == null) {
            return null;
        }
        List settings = this.getCampaign().getSettings().getSettings().stream().filter(s -> s.getClass() == settingClass).collect(Collectors.toList());
        if (settings.isEmpty()) {
            return null;
        }
        if (settings.size() != 1) {
            throw new IllegalArgumentException(String.format("Can only have 1 %s in Campaign Settings.", settingClass.getSimpleName()));
        }
        return (Setting)settings.get(0);
    }

    private void tryAddCampaignSettings() {
        Collection<CampaignType> campaignTypes = this.campaign.getCampaignType();
        if (campaignTypes.isEmpty()) {
            return;
        }
        if (campaignTypes.size() > 1) {
            throw new IllegalArgumentException("Can only have 1 campaign type in Campaign types.");
        }
        for (CampaignType type : campaignTypes) {
            this.addCampaignSettings(type);
        }
    }

    private void addCampaignSettings(CampaignType campaignType) {
        ArrayOfSetting arrayOfSettings = new ArrayOfSetting();
        ArrayList<Setting> settings = new ArrayList<Setting>();
        Setting setting = null;
        switch (campaignType) {
            case SEARCH: 
            case DYNAMIC_SEARCH_ADS: {
                setting = new DynamicSearchAdsSetting();
                setting.setType(DynamicSearchAdsSetting.class.getSimpleName());
                settings.add(setting);
                setting = new DisclaimerSetting();
                setting.setType(DisclaimerSetting.class.getSimpleName());
                settings.add(setting);
                break;
            }
            case AUDIENCE: {
                setting = new ShoppingSetting();
                setting.setType(ShoppingSetting.class.getSimpleName());
                settings.add(setting);
                setting = new DynamicFeedSetting();
                setting.setType(DynamicFeedSetting.class.getSimpleName());
                settings.add(setting);
                setting = new VerifiedTrackingSetting();
                setting.setType(VerifiedTrackingSetting.class.getSimpleName());
                settings.add(setting);
                break;
            }
            case SHOPPING: {
                setting = new ShoppingSetting();
                setting.setType(ShoppingSetting.class.getSimpleName());
                settings.add(setting);
                break;
            }
            case PERFORMANCE_MAX: {
                setting = new PerformanceMaxSetting();
                setting.setType(PerformanceMaxSetting.class.getSimpleName());
                settings.add(setting);
                setting = new ShoppingSetting();
                setting.setType(ShoppingSetting.class.getSimpleName());
                settings.add(setting);
                setting = new NewCustomerAcquisitionGoalSetting();
                setting.setType(NewCustomerAcquisitionGoalSetting.class.getSimpleName());
                settings.add(setting);
                break;
            }
            case APP: {
                setting = new AppSetting();
                setting.setType(AppSetting.class.getSimpleName());
                settings.add(setting);
            }
        }
        arrayOfSettings.getSettings().addAll(settings);
        setting = new TargetSetting();
        setting.setType(TargetSetting.class.getSimpleName());
        arrayOfSettings.getSettings().add(setting);
        this.campaign.setSettings(arrayOfSettings);
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public QualityScoreData getQualityScoreData() {
        return this.qualityScoreData;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getBidStrategyName() {
        return this.BidStrategyName;
    }

    public void setBidStrategyName(String bidStrategyName) {
        this.BidStrategyName = bidStrategyName;
    }

    public String getDestinationChannel() {
        return this.DestinationChannel;
    }

    public void setDestinationChannel(String destinationChannel) {
        this.DestinationChannel = destinationChannel;
    }

    public Boolean getIsMultiChannelCampaign() {
        return this.IsMultiChannelCampaign;
    }

    public void setIsMultiChannelCampaign(Boolean isMultiChannelCampaign) {
        this.IsMultiChannelCampaign = isMultiChannelCampaign;
    }

    public Boolean getShouldServeOnMSAN() {
        return this.ShouldServeOnMSAN;
    }

    public void setShouldServeOnMSAN(Boolean ShouldServeOnMSAN) {
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setCampaign(new Campaign());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.qualityScoreData = QualityScoreData.readFromRowValuesOrNull(values);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getCampaign(), "Campaign");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        if (!excludeReadonlyData) {
            QualityScoreData.writeToRowValuesIfNotNull(this.qualityScoreData, values);
        }
    }

    public static boolean isDailyBudget(BudgetLimitType budgetType) {
        return BudgetLimitType.DAILY_BUDGET_ACCELERATED.equals((Object)budgetType) || BudgetLimitType.DAILY_BUDGET_STANDARD.equals((Object)budgetType);
    }

    static {
        budgetToCsv = new BiConsumer<BulkCampaign, RowValues>(){

            @Override
            public void accept(BulkCampaign c, RowValues values) {
                BudgetLimitType budgetType = c.getCampaign().getBudgetType();
                if (budgetType == null) {
                    return;
                }
                Double budget = null;
                if (BulkCampaign.isDailyBudget(budgetType)) {
                    budget = c.getCampaign().getDailyBudget();
                }
                if (budget == null) {
                    return;
                }
                values.put("Budget", budget.toString());
            }
        };
        csvToBudget = new BiConsumer<RowValues, BulkCampaign>(){

            @Override
            public void accept(RowValues values, BulkCampaign c) {
                String budgetTypeRowValue = values.get("Budget Type");
                BudgetLimitType budgetType = StringExtensions.parseOptional(budgetTypeRowValue, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return StringExtensions.fromValueOptional(value, BudgetLimitType.class);
                    }
                });
                if (budgetType == null) {
                    return;
                }
                String budgetRowValue = values.get("Budget");
                if (budgetRowValue == null) {
                    return;
                }
                Double budgetValue = StringExtensions.nullOrDouble(budgetRowValue);
                c.getCampaign().setBudgetType(budgetType);
                if (BulkCampaign.isDailyBudget(budgetType)) {
                    c.getCampaign().setDailyBudget(budgetValue);
                }
            }
        };
        ArrayList<BulkMapping<Object>> m = new ArrayList<BulkMapping<Object>>();
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Campaign Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                if (c.getCampaign().getCampaignType().size() != 1) {
                    throw new IllegalArgumentException("Only 1 CampaignType can be set in Campaign");
                }
                Collection<CampaignType> campaignTypes = c.getCampaign().getCampaignType();
                return campaignTypes.toArray(new CampaignType[campaignTypes.size()])[0].value();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                CampaignType campaignType = StringExtensions.parseOptional(v, new Function<String, CampaignType>(){

                    @Override
                    public CampaignType apply(String value) {
                        return StringExtensions.fromValueOptional(value, CampaignType.class);
                    }
                });
                if (campaignType != null) {
                    c.getCampaign().setCampaignType(Collections.singleton(campaignType));
                    c.addCampaignSettings(campaignType);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getCampaign().getId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Status", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getStatus() != null ? c.getCampaign().getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setStatus(StringExtensions.parseOptional(v, new Function<String, CampaignStatus>(){

                    @Override
                    public CampaignStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, CampaignStatus.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Parent Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setAccountId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Campaign", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Time Zone", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getTimeZone();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setTimeZone(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Language", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.writeCampaignLanguages(";", c.getCampaign().getLanguages(), c.getCampaign().getId());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                ArrayOfstring languages = new ArrayOfstring();
                List<String> languageArray = StringExtensions.parseCampaignLanguages(v);
                if (languageArray == null) {
                    languages = null;
                } else {
                    languages.getStrings().addAll(languageArray);
                }
                c.getCampaign().setLanguages(languages);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBudgetType() != null ? c.getCampaign().getBudgetType().value() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBudgetType(StringExtensions.parseOptional(v, new Function<String, BudgetLimitType>(){

                    @Override
                    public BudgetLimitType apply(String value) {
                        return StringExtensions.fromValueOptional(value, BudgetLimitType.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Id", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBudgetId() != null ? c.getCampaign().getBudgetId().toString() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBudgetId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Budget Name", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getBudgetName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setBudgetName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Bid Strategy Id", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getBidStrategyId() != null ? c.getCampaign().getBidStrategyId().toString() : null;
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setBidStrategyId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Bid Strategy Name", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getBidStrategyName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setBidStrategyName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Feed Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicFeedSetting.class, false);
                return setting == null ? null : ((DynamicFeedSetting)setting).getFeedId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicFeedSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicFeedSetting)setting).setFeedId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Disclaimer Ads Enabled", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DisclaimerSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((DisclaimerSetting)setting).getDisclaimerAdsEnabled();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DisclaimerSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DisclaimerSetting)setting).setDisclaimerAdsEnabled(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Url Expansion Opt Out", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((PerformanceMaxSetting)setting).getFinalUrlExpansionOptOut();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(PerformanceMaxSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((PerformanceMaxSetting)setting).setFinalUrlExpansionOptOut(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaign>(budgetToCsv, csvToBudget));
        m.add(new SimpleBulkMapping<BulkCampaign, Integer>("Bid Adjustment", new Function<BulkCampaign, Integer>(){

            @Override
            public Integer apply(BulkCampaign c) {
                return c.getCampaign().getAudienceAdsBidAdjustment();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setAudienceAdsBidAdjustment(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("Store Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                return setting == null ? null : ((ShoppingSetting)setting).getStoreId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setStoreId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Integer>("Priority", new Function<BulkCampaign, Integer>(){

            @Override
            public Integer apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                return setting == null ? null : ((ShoppingSetting)setting).getPriority();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setPriority(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String s) {
                        return Integer.parseInt(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Country Code", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                return setting == null ? null : ((ShoppingSetting)setting).getSalesCountryCode();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setSalesCountryCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("LocalInventoryAdsEnabled", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return StringExtensions.toBooleanBulkString(((ShoppingSetting)setting).getLocalInventoryAdsEnabled());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setLocalInventoryAdsEnabled(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("ShoppableAdsEnabled", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return StringExtensions.toBooleanBulkString(((ShoppingSetting)setting).getShoppableAdsEnabled());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setShoppableAdsEnabled(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("FeedLabel", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((ShoppingSetting)setting).getFeedLabel();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(ShoppingSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((ShoppingSetting)setting).setFeedLabel(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Target Setting", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(TargetSetting.class, false);
                return StringExtensions.toBulkString((TargetSetting)setting);
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(TargetSetting.class, true);
                List<TargetSettingDetail> details = StringExtensions.parseTargetSettingDetails(v);
                if (setting == null || details == null) {
                    return;
                }
                TargetSetting targetSetting = new TargetSetting();
                targetSetting.setType(TargetSetting.class.getSimpleName());
                targetSetting.setDetails(new ArrayOfTargetSettingDetail());
                targetSetting.getDetails().getTargetSettingDetails().addAll(details);
                if (c.getCampaign().getSettings() == null) {
                    c.getCampaign().setSettings(new ArrayOfSetting());
                }
                c.getCampaign().getSettings().getSettings().add(setting);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Tracking Template", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toOptionalBulkString(c.getCampaign().getTrackingUrlTemplate(), c.getCampaign().getId());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Custom Parameter", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toCustomParaBulkString(c.getCampaign().getUrlCustomParameters(), c.getCampaign().getId());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                try {
                    c.getCampaign().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new ComplexBulkMapping<BulkCampaign>(new BiConsumer<BulkCampaign, RowValues>(){

            @Override
            public void accept(BulkCampaign c, RowValues values) {
                StringExtensions.writeBiddingScheme(c.getCampaign().getBiddingScheme(), c.getCampaign().getId(), values);
            }
        }, new BiConsumer<RowValues, BulkCampaign>(){

            @Override
            public void accept(RowValues values, BulkCampaign c) {
                BiddingScheme biddingScheme = StringExtensions.readBiddingScheme(values);
                if (biddingScheme != null) {
                    c.getCampaign().setBiddingScheme(biddingScheme);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Website", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((DynamicSearchAdsSetting)setting).getDomainName();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicSearchAdsSetting)setting).setDomainName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Dynamic Description Enabled", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((DynamicSearchAdsSetting)setting).getDynamicDescriptionEnabled();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicSearchAdsSetting)setting).setDynamicDescriptionEnabled(StringExtensions.parseOptional(v, new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String value) {
                        return Boolean.parseBoolean(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Domain Language", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((DynamicSearchAdsSetting)setting).getLanguage();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicSearchAdsSetting)setting).setLanguage(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Source", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting == null) {
                    return null;
                }
                DynamicSearchAdsSetting dsaSetting = (DynamicSearchAdsSetting)setting;
                if (dsaSetting.getSource() == null) {
                    return null;
                }
                return dsaSetting.getSource().value();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((DynamicSearchAdsSetting)setting).setSource(StringExtensions.parseOptional(v, new Function<String, DynamicSearchAdsSource>(){

                    @Override
                    public DynamicSearchAdsSource apply(String value) {
                        return StringExtensions.fromValueOptional(value, DynamicSearchAdsSource.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Sub Type", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getCampaign().getSubType();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setSubType(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Experiment Id", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toBulkString(c.getCampaign().getExperimentId());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setExperimentId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Final Url Suffix", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return StringExtensions.toOptionalBulkString(c.getCampaign().getFinalUrlSuffix(), c.getCampaign().getId());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Page Feed Ids", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, false);
                if (setting != null) {
                    DynamicSearchAdsSetting dsaSetting = (DynamicSearchAdsSetting)setting;
                    if (dsaSetting.getPageFeedIds() == null || dsaSetting.getPageFeedIds().getLongs() == null || dsaSetting.getPageFeedIds().getLongs().size() == 0) {
                        return null;
                    }
                    return StringExtensions.toIdListBulkString(";", dsaSetting.getPageFeedIds());
                }
                setting = c.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return null;
                }
                PerformanceMaxSetting performMaxSetting = (PerformanceMaxSetting)setting;
                if (performMaxSetting.getPageFeedIds() == null || performMaxSetting.getPageFeedIds().getLongs() == null || performMaxSetting.getPageFeedIds().getLongs().size() == 0) {
                    return null;
                }
                return StringExtensions.toIdListBulkString(";", performMaxSetting.getPageFeedIds());
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null || v == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(DynamicSearchAdsSetting.class, true);
                ArrayOflong ids = new ArrayOflong();
                List<Long> idArray = StringExtensions.parseIdList(v);
                if (idArray == null) {
                    ids = null;
                } else {
                    ids.getLongs().addAll(idArray);
                }
                if (setting != null) {
                    ((DynamicSearchAdsSetting)setting).setPageFeedIds(ids);
                } else {
                    setting = c.getCampaignSetting(PerformanceMaxSetting.class, true);
                    if (setting == null) {
                        return;
                    }
                    ((PerformanceMaxSetting)setting).setPageFeedIds(ids);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Ad Schedule Use Searcher Time Zone", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign t) {
                if (t.getCampaign().getAdScheduleUseSearcherTimeZone() == null) {
                    return null;
                }
                return StringExtensions.toUseSearcherTimeZoneBulkString(t.getCampaign().getAdScheduleUseSearcherTimeZone(), null);
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setAdScheduleUseSearcherTimeZone(StringExtensions.parseUseSearcherTimeZone(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Integer>("MultiMediaAdBidAdjustment", new Function<BulkCampaign, Integer>(){

            @Override
            public Integer apply(BulkCampaign c) {
                return c.getCampaign().getMultimediaAdsBidAdjustment();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setMultimediaAdsBidAdjustment(StringExtensions.parseOptionalInteger(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("Destination Channel", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                return c.getDestinationChannel();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setDestinationChannel(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Is Multi Channel Campaign", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign t) {
                return t.getIsMultiChannelCampaign();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setIsMultiChannelCampaign(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Auto Generated Image Assets Opt Out", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign t) {
                Setting setting = t.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return null;
                }
                PerformanceMaxSetting performMaxSetting = (PerformanceMaxSetting)setting;
                return performMaxSetting.getAutoGeneratedImageOptOut();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                Setting setting = c.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return;
                }
                ((PerformanceMaxSetting)setting).setAutoGeneratedImageOptOut(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Auto Generated Text Assets Opt Out", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign t) {
                Setting setting = t.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return null;
                }
                PerformanceMaxSetting performMaxSetting = (PerformanceMaxSetting)setting;
                return performMaxSetting.getAutoGeneratedTextOptOut();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                Setting setting = c.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return;
                }
                ((PerformanceMaxSetting)setting).setAutoGeneratedTextOptOut(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Cost Per Sale Opt Out", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign t) {
                Setting setting = t.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return null;
                }
                PerformanceMaxSetting performMaxSetting = (PerformanceMaxSetting)setting;
                return performMaxSetting.getCostPerSaleOptOut();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                Setting setting = c.getCampaignSetting(PerformanceMaxSetting.class, false);
                if (setting == null) {
                    return;
                }
                ((PerformanceMaxSetting)setting).setCostPerSaleOptOut(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Should Serve On MSAN", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign t) {
                return t.getShouldServeOnMSAN();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.setShouldServeOnMSAN(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("App Id", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(AppSetting.class, false);
                if (setting == null) {
                    return null;
                }
                return ((AppSetting)setting).getAppId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(AppSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((AppSetting)setting).setAppId(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, String>("App Store", new Function<BulkCampaign, String>(){

            @Override
            public String apply(BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return null;
                }
                Setting setting = c.getCampaignSetting(AppSetting.class, false);
                if (setting == null) {
                    return null;
                }
                if (((AppSetting)setting).getAppStore().size() != 1) {
                    throw new IllegalArgumentException("Only 1 App Store can be set in App Campaign");
                }
                Collection<AppStore> appStore = ((AppSetting)setting).getAppStore();
                return appStore.toArray(new AppStore[appStore.size()])[0].value();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(final String v, BulkCampaign c) {
                if (c.getCampaign().getCampaignType() == null) {
                    return;
                }
                Setting setting = c.getCampaignSetting(AppSetting.class, true);
                if (setting == null) {
                    return;
                }
                ((AppSetting)setting).setAppStore(StringExtensions.parseOptional(v, new Function<String, Collection<AppStore>>(){

                    @Override
                    public Collection<AppStore> apply(String value) {
                        return Collections.singletonList(StringExtensions.fromValueOptional(v, AppStore.class));
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Long>("New Customer Acquisition Goal Id", new Function<BulkCampaign, Long>(){

            @Override
            public Long apply(BulkCampaign t) {
                Setting setting = t.getCampaignSetting(NewCustomerAcquisitionGoalSetting.class, false);
                if (setting == null) {
                    return null;
                }
                NewCustomerAcquisitionGoalSetting newCustomerAcquisitionGoalSetting = (NewCustomerAcquisitionGoalSetting)setting;
                return newCustomerAcquisitionGoalSetting.getNewCustomerAcquisitionGoalId();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                Setting setting = c.getCampaignSetting(NewCustomerAcquisitionGoalSetting.class, false);
                if (setting == null) {
                    return;
                }
                ((NewCustomerAcquisitionGoalSetting)setting).setNewCustomerAcquisitionGoalId(v == null || v.isEmpty() ? null : Long.valueOf(Long.parseLong(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("New Customer Acquisition Bid Only Mode", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign t) {
                Setting setting = t.getCampaignSetting(NewCustomerAcquisitionGoalSetting.class, false);
                if (setting == null) {
                    return null;
                }
                NewCustomerAcquisitionGoalSetting newCustomerAcquisitionGoalSetting = (NewCustomerAcquisitionGoalSetting)setting;
                return newCustomerAcquisitionGoalSetting.getNewCustomerAcquisitionBidOnlyMode();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                Setting setting = c.getCampaignSetting(NewCustomerAcquisitionGoalSetting.class, false);
                if (setting == null) {
                    return;
                }
                ((NewCustomerAcquisitionGoalSetting)setting).setNewCustomerAcquisitionBidOnlyMode(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, BigDecimal>("Additional Conversion Value", new Function<BulkCampaign, BigDecimal>(){

            @Override
            public BigDecimal apply(BulkCampaign t) {
                Setting setting = t.getCampaignSetting(NewCustomerAcquisitionGoalSetting.class, false);
                if (setting == null) {
                    return null;
                }
                NewCustomerAcquisitionGoalSetting newCustomerAcquisitionGoalSetting = (NewCustomerAcquisitionGoalSetting)setting;
                return newCustomerAcquisitionGoalSetting.getAdditionalConversionValue();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                Setting setting = c.getCampaignSetting(NewCustomerAcquisitionGoalSetting.class, false);
                if (setting == null) {
                    return;
                }
                ((NewCustomerAcquisitionGoalSetting)setting).setAdditionalConversionValue(StringExtensions.nullOrBigDecimal(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaign, Boolean>("Is Political", new Function<BulkCampaign, Boolean>(){

            @Override
            public Boolean apply(BulkCampaign t) {
                return t.getCampaign().getIsPolitical();
            }
        }, new BiConsumer<String, BulkCampaign>(){

            @Override
            public void accept(String v, BulkCampaign c) {
                c.getCampaign().setIsPolitical(v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v)));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

