/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.Authentication;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.internal.IRestfulServiceFactory;
import com.microsoft.bingads.internal.OAuthWithAuthorizationCode;
import com.microsoft.bingads.internal.RestfulServiceFactoryFactory;
import com.microsoft.bingads.internal.ServiceUtils;
import java.util.HashMap;
import java.util.Map;

public class ServiceClient<T> {
    private final AuthorizationData authorizationData;
    private final Class<T> serviceInterface;
    private final IRestfulServiceFactory restfulServiceFactory;
    private ApiEnvironment environment;

    public ApiEnvironment getEnvironment() {
        return this.environment;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public ServiceClient(AuthorizationData authorizationData, Class<T> serviceInterface) {
        this(authorizationData, null, serviceInterface);
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface) {
        this.authorizationData = authorizationData;
        this.serviceInterface = serviceInterface;
        if (environment == null && authorizationData.getAuthentication() != null) {
            environment = authorizationData.getAuthentication().getEnvironment();
        }
        if (environment == null) {
            environment = ServiceUtils.getEnvironmentFromConfig();
        }
        if (environment == null) {
            environment = ApiEnvironment.PRODUCTION;
        }
        this.environment = environment;
        this.restfulServiceFactory = RestfulServiceFactoryFactory.createServiceFactory();
    }

    public T getService() {
        this.authorizationData.validate();
        Map<String, String> headers = this.buildHeaders();
        return this.createRestService(headers);
    }

    private Map<String, String> buildHeaders() {
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CustomerAccountId", Long.toString(this.authorizationData.getAccountId()));
        headers.put("CustomerId", Long.toString(this.authorizationData.getCustomerId()));
        headers.put("DeveloperToken", this.authorizationData.getDeveloperToken());
        Authentication authentication = this.authorizationData.getAuthentication();
        if (authentication instanceof OAuthWithAuthorizationCode) {
            ((OAuthWithAuthorizationCode)authentication).refreshTokensIfNeeded(false);
        }
        authentication.addHeaders(new HeadersImpl(){

            @Override
            public void addHeader(String name, String value) {
                headers.put(name, value);
            }
        });
        return headers;
    }

    T createRestService(Map<String, String> headers) {
        return this.restfulServiceFactory.createServiceClient(headers, this.environment, this.serviceInterface);
    }
}

