/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.reporting;

import com.microsoft.bingads.internal.RowValues;
import com.microsoft.bingads.v13.internal.reporting.CsvReportRecordReader;
import com.microsoft.bingads.v13.internal.reporting.RowReportHeaderParser;
import com.microsoft.bingads.v13.internal.reporting.RowReportRecord;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

class RowReportRecordReader
implements Iterator<RowReportRecord>,
AutoCloseable {
    private Iterator<String[]> lineIterator;
    private Map<String, Integer> columnMapping;
    private CsvReportRecordReader reader;
    private RowReportRecord nextRecord;
    private static final Pattern footerPattern = Pattern.compile("Total|\u00a9\\d+ Microsoft Corporation. All rights reserved.*");

    RowReportRecordReader(CsvReportRecordReader reader) {
        this.reader = reader;
        this.lineIterator = reader.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null;
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }

    @Override
    public RowReportRecord next() {
        RowReportRecord ret = this.nextRecord;
        this.nextRecord = null;
        this.peek();
        return ret;
    }

    private void peek() {
        if (this.lineIterator.hasNext()) {
            String[] fields = this.lineIterator.next();
            if (!this.validateRecord(fields)) {
                this.peek();
                return;
            }
            this.nextRecord = new RowReportRecord(new RowValues(fields, this.columnMapping));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    boolean readNextHeader(RowReportHeaderParser parser) {
        if (!this.lineIterator.hasNext()) {
            return false;
        }
        String[] fields = this.lineIterator.next();
        if (!this.validateHeader(fields)) {
            return this.readNextHeader(parser);
        }
        long validValueCount = Arrays.stream(fields).map(s -> s.trim()).filter(s -> s != null && s.length() > 0).count();
        if (validValueCount == 0L) {
            return false;
        }
        boolean header = parser.parseHeader(fields);
        if (validValueCount > 1L) {
            if (header) {
                this.columnMapping = this.generateColumnMapping(fields);
                this.peek();
            } else {
                this.nextRecord = new RowReportRecord(new RowValues(fields, this.columnMapping));
            }
            return false;
        }
        return true;
    }

    private Map<String, Integer> generateColumnMapping(String[] headers) {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (int i = 0; i < headers.length; ++i) {
            mapping.put(headers[i], i);
        }
        return mapping;
    }

    private boolean validateHeader(String[] fields) {
        if (fields == null) {
            return false;
        }
        long validValues = Arrays.stream(fields).map(s -> s.replace("-", "")).map(s -> s.trim()).filter(s -> s != null && s.length() > 0).count();
        return validValues >= 1L;
    }

    private boolean validateRecord(String[] fields) {
        if (fields == null) {
            return false;
        }
        long validValues = Arrays.stream(fields).map(s -> s.replace("-", "")).map(s -> s.trim()).filter(s -> s != null && s.length() > 0).count();
        if (validValues == 0L) {
            return false;
        }
        return !footerPattern.matcher(fields[0]).matches();
    }
}

