/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOflong;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.ImageAdExtension;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkImageAdExtension
extends BulkAdExtension<ImageAdExtension> {
    private static final List<BulkMapping<BulkImageAdExtension>> MAPPINGS;

    public ImageAdExtension getImageAdExtension() {
        return (ImageAdExtension)this.getAdExtension();
    }

    public void setImageAdExtension(ImageAdExtension imageAdExtension) {
        this.setAdExtension(imageAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        ImageAdExtension extension = new ImageAdExtension();
        extension.setType("ImageAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getImageAdExtension(), "ImageAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkImageAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkImageAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Destination Url", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toOptionalBulkString(c.getImageAdExtension().getDestinationUrl(), c.getImageAdExtension().getId());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                c.getImageAdExtension().setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Alternative Text", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return c.getImageAdExtension().getAlternativeText();
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                c.getImageAdExtension().setAlternativeText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Media Ids", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toIdListBulkString(";", c.getImageAdExtension().getImageMediaIds());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ArrayOflong ids = new ArrayOflong();
                List<Long> idArray = StringExtensions.parseIdList(v);
                if (idArray == null) {
                    ids = null;
                } else {
                    ids.getLongs().addAll(idArray);
                }
                c.getImageAdExtension().setImageMediaIds(ids);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Final Url", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.writeUrls("; ", ((ImageAdExtension)c.getAdExtension()).getFinalUrls(), ((ImageAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((ImageAdExtension)c.getAdExtension()).setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Mobile Final Url", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.writeUrls("; ", ((ImageAdExtension)c.getAdExtension()).getFinalMobileUrls(), ((ImageAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((ImageAdExtension)c.getAdExtension()).setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Tracking Template", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toOptionalBulkString(((ImageAdExtension)c.getAdExtension()).getTrackingUrlTemplate(), ((ImageAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ((ImageAdExtension)c.getAdExtension()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Custom Parameter", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toCustomParaBulkString(((ImageAdExtension)c.getAdExtension()).getUrlCustomParameters(), ((ImageAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                try {
                    ((ImageAdExtension)c.getAdExtension()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Final Url Suffix", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toOptionalBulkString(((ImageAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((ImageAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ((ImageAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Images", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toImageAssetLinksBulkString(((ImageAdExtension)c.getAdExtension()).getImages());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ((ImageAdExtension)c.getAdExtension()).setImages(StringExtensions.parseImageAssetLinks(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Layouts", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.WriteDelimitedStrings(";", ((ImageAdExtension)c.getAdExtension()).getLayouts());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ((ImageAdExtension)c.getAdExtension()).setLayouts(StringExtensions.ParseDelimitedStrings(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Display Text", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toOptionalBulkString(((ImageAdExtension)c.getAdExtension()).getDisplayText(), ((ImageAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                ((ImageAdExtension)c.getAdExtension()).setDisplayText(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

