/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkCampaignNegativeCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.LocationCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignNegativeLocationCriterion
extends BulkCampaignNegativeCriterion {
    private static final List<BulkMapping<BulkCampaignNegativeLocationCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new LocationCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignNegativeLocationCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkCampaignNegativeLocationCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkCampaignNegativeLocationCriterion, String>("Target", new Function<BulkCampaignNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignNegativeLocationCriterion c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    Long locationId = ((LocationCriterion)c.getNegativeCampaignCriterion().getCriterion()).getLocationId();
                    return locationId == null ? null : locationId.toString();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeLocationCriterion c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeCampaignCriterion().getCriterion()).setLocationId(Long.parseLong(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeLocationCriterion, String>("Sub Type", new Function<BulkCampaignNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignNegativeLocationCriterion c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getNegativeCampaignCriterion().getCriterion()).getLocationType();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeLocationCriterion c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeCampaignCriterion().getCriterion()).setLocationType(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeLocationCriterion, String>("Name", new Function<BulkCampaignNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkCampaignNegativeLocationCriterion c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getNegativeCampaignCriterion().getCriterion()).getDisplayName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeLocationCriterion c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeCampaignCriterion().getCriterion()).setDisplayName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

