/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkCampaignBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.DealCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignDealCriterion
extends BulkCampaignBiddableCriterion {
    private static final List<BulkMapping<BulkCampaignDealCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        return new DealCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignDealCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkCampaignDealCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkCampaignDealCriterion, String>("Target", new Function<BulkCampaignDealCriterion, String>(){

            @Override
            public String apply(BulkCampaignDealCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DealCriterion) {
                    Long dealId = ((DealCriterion)c.getBiddableCampaignCriterion().getCriterion()).getDealId();
                    return dealId == null ? null : dealId.toString();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDealCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDealCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DealCriterion) {
                    ((DealCriterion)c.getBiddableCampaignCriterion().getCriterion()).setDealId(Long.parseLong(v));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

