/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAd;
import com.microsoft.bingads.v13.campaignmanagement.AdType;
import com.microsoft.bingads.v13.campaignmanagement.AppInstallAd;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAppInstallAd
extends BulkAd<AppInstallAd> {
    private static final List<BulkMapping<BulkAppInstallAd>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAppInstallAd(), "AppInstallAd");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAd(new AppInstallAd());
        ((AppInstallAd)this.getAd()).setType(AdType.APP_INSTALL);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public AppInstallAd getAppInstallAd() {
        return (AppInstallAd)this.ad;
    }

    public void setAppInstallAd(AppInstallAd ad) {
        this.setAd(ad);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAppInstallAd, String>> m = new ArrayList<SimpleBulkMapping<BulkAppInstallAd, String>>();
        m.add(new SimpleBulkMapping<BulkAppInstallAd, String>("App Platform", new Function<BulkAppInstallAd, String>(){

            @Override
            public String apply(BulkAppInstallAd c) {
                return c.getAppInstallAd().getAppPlatform();
            }
        }, new BiConsumer<String, BulkAppInstallAd>(){

            @Override
            public void accept(String v, BulkAppInstallAd c) {
                c.getAppInstallAd().setAppPlatform(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAppInstallAd, String>("App Id", new Function<BulkAppInstallAd, String>(){

            @Override
            public String apply(BulkAppInstallAd c) {
                return c.getAppInstallAd().getAppStoreId();
            }
        }, new BiConsumer<String, BulkAppInstallAd>(){

            @Override
            public void accept(String v, BulkAppInstallAd c) {
                c.getAppInstallAd().setAppStoreId(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAppInstallAd, String>("Title", new Function<BulkAppInstallAd, String>(){

            @Override
            public String apply(BulkAppInstallAd c) {
                return ((AppInstallAd)c.getAd()).getTitle();
            }
        }, new BiConsumer<String, BulkAppInstallAd>(){

            @Override
            public void accept(String v, BulkAppInstallAd c) {
                ((AppInstallAd)c.getAd()).setTitle(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAppInstallAd, String>("Text", new Function<BulkAppInstallAd, String>(){

            @Override
            public String apply(BulkAppInstallAd c) {
                return ((AppInstallAd)c.getAd()).getText();
            }
        }, new BiConsumer<String, BulkAppInstallAd>(){

            @Override
            public void accept(String v, BulkAppInstallAd c) {
                ((AppInstallAd)c.getAd()).setText(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

