/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.internal.ServiceInfo;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.v13.adinsight.IAdInsightService;
import com.microsoft.bingads.v13.bulk.IBulkService;
import com.microsoft.bingads.v13.campaignmanagement.ICampaignManagementService;
import com.microsoft.bingads.v13.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.v13.customermanagement.ICustomerManagementService;
import com.microsoft.bingads.v13.reporting.IReportingService;
import java.util.HashMap;
import java.util.Map;

public class ServiceFactoryImpl {
    public static final String VERSION = "13.0.25.1";
    private static final int DEFAULT_WS_CREATE_TIMEOUT_IN_SECOND = 60;
    private static final int WS_CREATE_RETRY_INTERVAL_IN_SECOND = 5;
    private static final int WS_CREATE_RETRY_TIMES = 3;
    public static final Map<Class<?>, ServiceInfo> endpoints = new HashMap<Class<?>, ServiceInfo>(){
        {
            this.put(ICustomerBillingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/Billing/v13/CustomerBillingService.svc");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/Api/Billing/v13/CustomerBillingService.svc");
                    this.setServiceNameAndVersion("CustomerBilling/v13");
                }
            });
            this.put(ICustomerManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Api/CustomerManagement/v13/CustomerManagementService.svc");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/Api/CustomerManagement/v13/CustomerManagementService.svc");
                    this.setServiceNameAndVersion("CustomerManagement/v13");
                }
            });
            this.put(IReportingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://reporting.api.bingads.microsoft.com/Api/Advertiser/Reporting/v13/ReportingService.svc");
                    this.setSandboxUrl("https://reporting.api.sandbox.bingads.microsoft.com/Api/Advertiser/Reporting/v13/ReportingService.svc");
                    this.setServiceNameAndVersion("Reporting/v13");
                }
            });
            this.put(ICampaignManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://campaign.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/CampaignManagementService.svc");
                    this.setSandboxUrl("https://campaign.api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/CampaignManagementService.svc");
                    this.setServiceNameAndVersion("CampaignManagement/v13");
                }
            });
            this.put(IAdInsightService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://adinsight.api.bingads.microsoft.com/Api/Advertiser/AdInsight/v13/AdInsightService.svc");
                    this.setSandboxUrl("https://adinsight.api.sandbox.bingads.microsoft.com/Api/Advertiser/AdInsight/v13/AdInsightService.svc");
                    this.setServiceNameAndVersion("AdInsight/v13");
                }
            });
            this.put(IBulkService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://bulk.api.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/BulkService.svc");
                    this.setSandboxUrl("https://bulk.api.sandbox.bingads.microsoft.com/Api/Advertiser/CampaignManagement/v13/BulkService.svc");
                    this.setServiceNameAndVersion("Bulk/v13");
                }
            });
        }
    };

    private String getServiceUrl(Class serviceInterface, ApiEnvironment env) {
        String serviceUrl = ServiceUtils.getServiceUrlFromConfig(serviceInterface);
        if (serviceUrl == null) {
            ServiceInfo serviceInfo = endpoints.get(serviceInterface);
            serviceUrl = serviceInfo.GetUrl(env);
        }
        return serviceUrl;
    }

    protected <T> void configServiceProxy(T port) {
    }
}

