/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.BrandList;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkBrandList
extends SingleRecordBulkEntity {
    private Long accountId;
    private BrandList brandList;
    private static final List<BulkMapping<BulkBrandList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        BrandList BrandList2 = new BrandList();
        this.setBrandList(BrandList2);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getBrandList(), "BrandList");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public BrandList getBrandList() {
        return this.brandList;
    }

    public void setBrandList(BrandList brandList) {
        this.brandList = brandList;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkBrandList, Object>> m = new ArrayList<SimpleBulkMapping<BulkBrandList, Object>>();
        m.add(new SimpleBulkMapping<BulkBrandList, Long>("Id", new Function<BulkBrandList, Long>(){

            @Override
            public Long apply(BulkBrandList c) {
                return c.getBrandList().getId();
            }
        }, new BiConsumer<String, BulkBrandList>(){

            @Override
            public void accept(String v, BulkBrandList c) {
                c.getBrandList().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBrandList, Long>("Parent Id", new Function<BulkBrandList, Long>(){

            @Override
            public Long apply(BulkBrandList c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkBrandList>(){

            @Override
            public void accept(String v, BulkBrandList c) {
                c.setAccountId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkBrandList, String>("Name", new Function<BulkBrandList, String>(){

            @Override
            public String apply(BulkBrandList c) {
                return c.getBrandList().getName();
            }
        }, new BiConsumer<String, BulkBrandList>(){

            @Override
            public void accept(String v, BulkBrandList c) {
                c.getBrandList().setName(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

