/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupNegativeCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.LocationCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeLocationCriterion
extends BulkAdGroupNegativeCriterion {
    private static final List<BulkMapping<BulkAdGroupNegativeLocationCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        return new LocationCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Target", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    Long locationId = ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getLocationId();
                    return locationId == null ? null : locationId.toString();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setLocationId(Long.parseLong(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Sub Type", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getLocationType();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setLocationType(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Name", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getDisplayName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setDisplayName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

