/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.bulk;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.RowValues;

public class ComplexBulkMapping<TEntity>
implements BulkMapping<TEntity> {
    private BiConsumer<TEntity, RowValues> entityToCsv;
    private BiConsumer<RowValues, TEntity> csvToEntity;

    public ComplexBulkMapping(BiConsumer<TEntity, RowValues> entityToCsv, BiConsumer<RowValues, TEntity> csvToEntity) {
        this.entityToCsv = entityToCsv;
        this.csvToEntity = csvToEntity;
    }

    @Override
    public void convertToEntity(RowValues values, TEntity entity) {
        this.csvToEntity.accept(values, entity);
    }

    @Override
    public void convertToCsv(TEntity entity, RowValues values) {
        if (this.entityToCsv == null) {
            return;
        }
        this.entityToCsv.accept(entity, values);
    }
}

