/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkConversionGoal;
import com.microsoft.bingads.v13.campaignmanagement.EventGoal;
import com.microsoft.bingads.v13.campaignmanagement.ExpressionOperator;
import com.microsoft.bingads.v13.campaignmanagement.ValueOperator;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkEventGoal
extends BulkConversionGoal<EventGoal> {
    private static final List<BulkMapping<BulkEventGoal>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public EventGoal getEventGoal() {
        return (EventGoal)this.getConversionGoal();
    }

    public void setEventGoal(EventGoal EventGoal2) {
        this.setConversionGoal(EventGoal2);
    }

    @Override
    public EventGoal createConversionGoal() {
        return new EventGoal();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkEventGoal, String>> m = new ArrayList<SimpleBulkMapping<BulkEventGoal, String>>();
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Category Expression", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal c) {
                return c.getEventGoal().getCategoryExpression();
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setCategoryExpression(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Category Operator", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal c) {
                return c.getEventGoal().getCategoryOperator() != null ? c.getEventGoal().getCategoryOperator().value() : null;
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setCategoryOperator(StringExtensions.parseOptional(v, new Function<String, ExpressionOperator>(){

                    @Override
                    public ExpressionOperator apply(String value) {
                        return StringExtensions.fromValueOptional(value, ExpressionOperator.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Action Expression", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal c) {
                return c.getEventGoal().getActionExpression();
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setActionExpression(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Action Operator", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal c) {
                return c.getEventGoal().getActionOperator() != null ? c.getEventGoal().getActionOperator().value() : null;
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setActionOperator(StringExtensions.parseOptional(v, new Function<String, ExpressionOperator>(){

                    @Override
                    public ExpressionOperator apply(String value) {
                        return StringExtensions.fromValueOptional(value, ExpressionOperator.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Label Expression", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal c) {
                return c.getEventGoal().getLabelExpression();
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setLabelExpression(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Label Operator", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal c) {
                return c.getEventGoal().getLabelOperator() != null ? c.getEventGoal().getLabelOperator().value() : null;
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setLabelOperator(StringExtensions.parseOptional(v, new Function<String, ExpressionOperator>(){

                    @Override
                    public ExpressionOperator apply(String value) {
                        return StringExtensions.fromValueOptional(value, ExpressionOperator.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Event Value", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal t) {
                return t.getEventGoal().getValue() != null ? t.getEventGoal().getValue().toString() : null;
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setValue(StringExtensions.nullOrBigDecimal(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkEventGoal, String>("Event Value Operator", new Function<BulkEventGoal, String>(){

            @Override
            public String apply(BulkEventGoal c) {
                return c.getEventGoal().getValueOperator() != null ? c.getEventGoal().getValueOperator().value() : null;
            }
        }, new BiConsumer<String, BulkEventGoal>(){

            @Override
            public void accept(String v, BulkEventGoal c) {
                c.getEventGoal().setValueOperator(StringExtensions.parseOptional(v, new Function<String, ValueOperator>(){

                    @Override
                    public ValueOperator apply(String value) {
                        return StringExtensions.fromValueOptional(value, ValueOperator.class);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

