/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkFeed
extends SingleRecordBulkEntity {
    private Long id;
    private Long accountId;
    private String name;
    private Status status;
    private String subType;
    private String schedule;
    private List<FeedCustomAttribute> customAttributes;
    private static final List<BulkMapping<BulkFeed>> MAPPINGS;

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public List<FeedCustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<FeedCustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkFeed, Object>> m = new ArrayList<SimpleBulkMapping<BulkFeed, Object>>();
        m.add(new SimpleBulkMapping<BulkFeed, Long>("Id", new Function<BulkFeed, Long>(){

            @Override
            public Long apply(BulkFeed t) {
                return t.getId();
            }
        }, new BiConsumer<String, BulkFeed>(){

            @Override
            public void accept(String v, BulkFeed c) {
                c.setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFeed, Long>("Parent Id", new Function<BulkFeed, Long>(){

            @Override
            public Long apply(BulkFeed c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkFeed>(){

            @Override
            public void accept(String v, BulkFeed c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFeed, String>("Status", new Function<BulkFeed, String>(){

            @Override
            public String apply(BulkFeed t) {
                return t.getStatus() != null ? t.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkFeed>(){

            @Override
            public void accept(String v, BulkFeed c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFeed, String>("Feed Name", new Function<BulkFeed, String>(){

            @Override
            public String apply(BulkFeed t) {
                return t.getName();
            }
        }, new BiConsumer<String, BulkFeed>(){

            @Override
            public void accept(String v, BulkFeed c) {
                c.setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFeed, String>("Sub Type", new Function<BulkFeed, String>(){

            @Override
            public String apply(BulkFeed t) {
                return t.getSubType();
            }
        }, new BiConsumer<String, BulkFeed>(){

            @Override
            public void accept(String v, BulkFeed c) {
                c.setSubType(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkFeed, String>("Custom Attributes", new Function<BulkFeed, String>(){

            @Override
            public String apply(BulkFeed t) {
                return StringExtensions.ToFeedCustomAttributesBulkString(t.getCustomAttributes());
            }
        }, new BiConsumer<String, BulkFeed>(){

            @Override
            public void accept(String v, BulkFeed c) {
                c.setCustomAttributes(StringExtensions.parseFeedCustomAttributes(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkFeed, String>("Schedule", new Function<BulkFeed, String>(){

            @Override
            public String apply(BulkFeed t) {
                return t.getSchedule();
            }
        }, new BiConsumer<String, BulkFeed>(){

            @Override
            public void accept(String v, BulkFeed c) {
                c.setSchedule(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FeedCustomAttribute {
        private String feedAttributeType;
        private String name;
        private boolean isPartOfKey;

        public String getFeedAttributeType() {
            return this.feedAttributeType;
        }

        public void setFeedAttributeType(String feedAttributeType) {
            this.feedAttributeType = feedAttributeType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean getIsPartOfKey() {
            return this.isPartOfKey;
        }

        public void setIsPartOfKey(boolean isPartOfKey) {
            this.isPartOfKey = isPartOfKey;
        }
    }
}

