/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.Video;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkVideo
extends SingleRecordBulkEntity {
    private Long accountId;
    private Video video;
    private static final List<BulkMapping<BulkVideo>> MAPPINGS;

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setVideo(new Video());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getVideo(), "Video");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkVideo, Object>> m = new ArrayList<SimpleBulkMapping<BulkVideo, Object>>();
        m.add(new SimpleBulkMapping<BulkVideo, Long>("Id", new Function<BulkVideo, Long>(){

            @Override
            public Long apply(BulkVideo t) {
                return t.getVideo().getId();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, Long>("Parent Id", new Function<BulkVideo, Long>(){

            @Override
            public Long apply(BulkVideo t) {
                return t.getAccountId();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, String>("Status", new Function<BulkVideo, String>(){

            @Override
            public String apply(BulkVideo t) {
                return t.getVideo().getStatus();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setStatus(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, String>("Description", new Function<BulkVideo, String>(){

            @Override
            public String apply(BulkVideo t) {
                return t.getVideo().getDescription();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, String>("Aspect Ratio", new Function<BulkVideo, String>(){

            @Override
            public String apply(BulkVideo t) {
                return t.getVideo().getAspectRatio();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setAspectRatio(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, String>("Url", new Function<BulkVideo, String>(){

            @Override
            public String apply(BulkVideo t) {
                return t.getVideo().getUrl();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, String>("Source Url", new Function<BulkVideo, String>(){

            @Override
            public String apply(BulkVideo t) {
                return t.getVideo().getSourceUrl();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setSourceUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, String>("Thumbnail Url", new Function<BulkVideo, String>(){

            @Override
            public String apply(BulkVideo t) {
                return t.getVideo().getThumbnailUrl();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setThumbnailUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideo, Integer>("Duration In Milliseconds", new Function<BulkVideo, Integer>(){

            @Override
            public Integer apply(BulkVideo t) {
                return t.getVideo().getDurationInMilliseconds();
            }
        }, new BiConsumer<String, BulkVideo>(){

            @Override
            public void accept(String v, BulkVideo c) {
                c.getVideo().setDurationInMilliseconds(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

