/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.reporting;

import com.microsoft.bingads.v13.internal.reporting.ReportHeader;
import com.microsoft.bingads.v13.internal.reporting.RowReportHeaderParser;
import com.microsoft.bingads.v13.internal.reporting.RowReportStreamReader;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RowReportHeader
extends ReportHeader
implements RowReportHeaderParser {
    private static final String REPORT_NAME = "Report Name";
    private static final String REPORT_TIME = "Report Time";
    private static final String REPORT_AGGREGATION = "Report Aggregation";
    private static final String REPORT_FILTER = "Report Filter";
    private static final String TIME_ZONE = "Time Zone";
    private static final String ROWS = "Rows";
    private static final String LAST_COMPLETED_AVAILABLE_DAY = "Last Completed Available Day";
    public static final String POTENTIAL_INCOMPLETE_DATA = "Potential Incomplete Data";
    private static final Pattern headerPattern = Pattern.compile("^(Potential Incomplete Data|Report Name|Report Time|Report Aggregation|Report Filter|Time Zone|Rows|Last Completed Available Day|Last Completed Available Hour): (.*)$");
    private RowReportStreamReader reportStreamReader;

    RowReportHeader(RowReportStreamReader reportStreamReader) {
        this.reportStreamReader = reportStreamReader;
        this.readReportHeader();
    }

    private void readReportHeader() {
        this.reportStreamReader.readReportHeader(this);
    }

    @Override
    public boolean parseHeader(String[] fields) {
        long validValueCount = Arrays.stream(fields).map(s -> s.trim()).filter(s -> s != null && s.length() > 0).count();
        if (validValueCount == 1L && fields[0].contains(":")) {
            this.parseReportMetadata(fields[0]);
            return true;
        }
        return this.setReportColumns(fields);
    }

    private void parseReportMetadata(String header) {
        if (header == null) {
            return;
        }
        Matcher matcher = headerPattern.matcher(header);
        if (!matcher.matches()) {
            return;
        }
        String headerName = matcher.group(1);
        String headerValue = matcher.group(2).trim();
        switch (headerName) {
            case "Report Name": {
                this.setReportName(headerValue);
                break;
            }
            case "Report Time": {
                this.setReportTime(headerValue);
                break;
            }
            case "Time Zone": {
                this.setReportTimeZone(headerValue);
                break;
            }
            case "Last Completed Available Day": {
                this.setLastCompletedAvailableDate(headerValue);
                break;
            }
            case "Report Aggregation": {
                this.setReportAggregation(headerValue);
                break;
            }
            case "Report Filter": {
                this.setReportFilter(headerValue);
                break;
            }
            case "Rows": {
                this.setReportRecordCount(headerValue);
                break;
            }
            case "Potential Incomplete Data": {
                this.setPotentialIncompleteData(headerValue);
                break;
            }
        }
    }
}

