/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAudience;
import com.microsoft.bingads.v13.campaignmanagement.ImpressionBasedEntityType;
import com.microsoft.bingads.v13.campaignmanagement.ImpressionBasedRemarketingList;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkImpressionBasedRemarketingList
extends BulkAudience<ImpressionBasedRemarketingList> {
    private static final List<BulkMapping<BulkImpressionBasedRemarketingList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public ImpressionBasedRemarketingList getImpressionBasedRemarketingList() {
        return (ImpressionBasedRemarketingList)this.getAudience();
    }

    public void setImpressionBasedRemarketingList(ImpressionBasedRemarketingList remarketingList) {
        this.setAudience(remarketingList);
    }

    @Override
    public ImpressionBasedRemarketingList createAudience() {
        return new ImpressionBasedRemarketingList();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkImpressionBasedRemarketingList, Object>> m = new ArrayList<SimpleBulkMapping<BulkImpressionBasedRemarketingList, Object>>();
        m.add(new SimpleBulkMapping<BulkImpressionBasedRemarketingList, Long>("Impression Campaign Id", new Function<BulkImpressionBasedRemarketingList, Long>(){

            @Override
            public Long apply(BulkImpressionBasedRemarketingList c) {
                return c.getImpressionBasedRemarketingList().getCampaignId();
            }
        }, new BiConsumer<String, BulkImpressionBasedRemarketingList>(){

            @Override
            public void accept(String v, BulkImpressionBasedRemarketingList c) {
                c.getImpressionBasedRemarketingList().setCampaignId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImpressionBasedRemarketingList, Long>("Impression Ad Group Id", new Function<BulkImpressionBasedRemarketingList, Long>(){

            @Override
            public Long apply(BulkImpressionBasedRemarketingList c) {
                return c.getImpressionBasedRemarketingList().getAdGroupId();
            }
        }, new BiConsumer<String, BulkImpressionBasedRemarketingList>(){

            @Override
            public void accept(String v, BulkImpressionBasedRemarketingList c) {
                c.getImpressionBasedRemarketingList().setAdGroupId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImpressionBasedRemarketingList, String>("Entity Type", new Function<BulkImpressionBasedRemarketingList, String>(){

            @Override
            public String apply(BulkImpressionBasedRemarketingList c) {
                return c.getImpressionBasedRemarketingList().getEntityType() != null ? c.getImpressionBasedRemarketingList().getEntityType().value() : null;
            }
        }, new BiConsumer<String, BulkImpressionBasedRemarketingList>(){

            @Override
            public void accept(String v, BulkImpressionBasedRemarketingList c) {
                c.getImpressionBasedRemarketingList().setEntityType(StringExtensions.parseOptional(v, new Function<String, ImpressionBasedEntityType>(){

                    @Override
                    public ImpressionBasedEntityType apply(String value) {
                        return StringExtensions.fromValueOptional(value, ImpressionBasedEntityType.class);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

