/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkImage
extends SingleRecordBulkEntity {
    private Long id;
    private Long accountId;
    private Status status;
    private String text;
    private String subType;
    private String url;
    private Integer width;
    private Integer height;
    private static final List<BulkMapping<BulkImage>> MAPPINGS;

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkImage, Object>> m = new ArrayList<SimpleBulkMapping<BulkImage, Object>>();
        m.add(new SimpleBulkMapping<BulkImage, Long>("Id", new Function<BulkImage, Long>(){

            @Override
            public Long apply(BulkImage t) {
                return t.getId();
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImage, Long>("Parent Id", new Function<BulkImage, Long>(){

            @Override
            public Long apply(BulkImage c) {
                return c.getAccountId();
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setAccountId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImage, String>("Status", new Function<BulkImage, String>(){

            @Override
            public String apply(BulkImage t) {
                return t.getStatus() != null ? t.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImage, String>("Text", new Function<BulkImage, String>(){

            @Override
            public String apply(BulkImage t) {
                return t.getText();
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImage, String>("Url", new Function<BulkImage, String>(){

            @Override
            public String apply(BulkImage t) {
                return t.getUrl();
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImage, String>("Sub Type", new Function<BulkImage, String>(){

            @Override
            public String apply(BulkImage t) {
                return t.getSubType();
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setSubType(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImage, Integer>("Width", new Function<BulkImage, Integer>(){

            @Override
            public Integer apply(BulkImage c) {
                return c.getWidth();
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setWidth(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkImage, Integer>("Height", new Function<BulkImage, Integer>(){

            @Override
            public Integer apply(BulkImage c) {
                return c.getHeight();
            }
        }, new BiConsumer<String, BulkImage>(){

            @Override
            public void accept(String v, BulkImage c) {
                c.setHeight(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

