/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful.adaptor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.microsoft.bingads.internal.restful.adaptor.AdaptorUtil;
import java.io.IOException;
import java.util.Collection;

public class EnumListSerializer
extends StdSerializer<Collection<?>>
implements ContextualSerializer {
    private Class<?> clazz;

    public EnumListSerializer() {
        super(Collection.class, false);
    }

    public EnumListSerializer(Class<?> clazz) {
        super(clazz, false);
        this.clazz = clazz;
    }

    public void serialize(Collection<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (Object v : value) {
            sb.append(AdaptorUtil.toCamelcase(v) + ", ");
        }
        sb.setLength(sb.length() - 2);
        gen.writeObject((Object)sb.toString());
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Class clazz = property.getType().getRawClass();
        return new EnumListSerializer(clazz);
    }
}

