/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.GlobalSettings;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.restful.ResponseInfo;
import com.microsoft.bingads.internal.restful.adaptor.AdaptorUtil;
import com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.arrayOfTypes.AddMixInForArrayOfTypes;
import com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.enums.AddMixInForComplexTypesWithEnumList;
import com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.enums.AddMixInForEnumTypes;
import com.microsoft.bingads.internal.restful.adaptor.generated.reporting.polymorphicTypes.AddMixInForPolymorphicTypes;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import jakarta.xml.ws.AsyncHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;

class RestfulServiceClient {
    protected static final String HttpPost = "POST";
    protected static final String HttpPut = "PUT";
    protected static final String HttpDelete = "DELETE";
    protected Map<String, String> headers;
    protected ApiEnvironment environment;
    private Class<?> serviceInterface;
    private static final ConcurrentHashMap<Class<?>, Calendar> retryAfter = new ConcurrentHashMap();
    private static final ArrayList<Integer> statusCodesForApplicationFault = new ArrayList<Integer>(Arrays.asList(400, 401, 403, 429, 500));
    private static final ArrayList<Integer> statusCodesForSwitchToSoap = new ArrayList<Integer>(Arrays.asList(404, 501));
    private static final String userAgent = RestfulServiceClient.getUserAgent();
    private boolean enableFallbackToSoap;

    protected RestfulServiceClient(Map<String, String> headers, ApiEnvironment env, Class<?> serviceInterface) {
        this.headers = headers;
        this.environment = env;
        this.serviceInterface = serviceInterface;
        this.enableFallbackToSoap = ServiceUtils.getFallbackFlag();
    }

    private static String getUserAgent() {
        String actualUserAgent = "BingAdsSDKJava.RestApi";
        String clientName = ServiceUtils.getClientName();
        if (clientName != null) {
            actualUserAgent = actualUserAgent + "." + clientName;
        }
        actualUserAgent = actualUserAgent + "/13.0.20";
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.matches("\\d+[\\d|\\.|\\_]*\\d+")) {
            actualUserAgent = actualUserAgent + "_" + javaVersion;
        }
        return actualUserAgent;
    }

    private Invocation.Builder createRequestBuilder(String entityEndpointPath) {
        WebTarget targetForService = GlobalSettings.getHttpClientProvider().get(this.serviceInterface, this.environment);
        Invocation.Builder builder = targetForService.path(entityEndpointPath).request();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if ("AuthenticationToken".equals(name)) {
                builder.header("Authorization", (Object)("Bearer " + value));
                continue;
            }
            builder.header(name, (Object)value);
        }
        builder.header("User-Agent", (Object)userAgent);
        return builder;
    }

    private void SetRetryAfterTime(String value) {
        int delta;
        try {
            delta = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            delta = 3600;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(13, delta);
        retryAfter.put(this.serviceInterface, cal);
    }

    protected <TRequest, TResponse, TFaultDetail> ResponseInfo<TResponse, TFaultDetail> getResponseInfo(TRequest request, String entityEndpoint, String verb, Class<TResponse> responseClass, Class<TFaultDetail> faultDetailClass) {
        Response httpResponse;
        String jsonRequest;
        if (retryAfter.get(this.serviceInterface) != null && this.enableFallbackToSoap && Calendar.getInstance().before(retryAfter.get(this.serviceInterface))) {
            return null;
        }
        try {
            jsonRequest = AdaptorUtil.mapper.writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            throw new InternalException(e);
        }
        Invocation.Builder builder = this.createRequestBuilder(entityEndpoint);
        switch (verb) {
            case "POST": {
                httpResponse = builder.post(Entity.json((Object)jsonRequest));
                break;
            }
            case "PUT": {
                httpResponse = builder.put(Entity.json((Object)jsonRequest));
                break;
            }
            case "DELETE": {
                httpResponse = builder.method(HttpDelete, Entity.json((Object)jsonRequest));
                break;
            }
            default: {
                throw new InternalException("Unknown HTTP verb: " + verb);
            }
        }
        int statusCode = httpResponse.getStatus();
        if (statusCodesForSwitchToSoap.contains(statusCode) && this.enableFallbackToSoap) {
            this.SetRetryAfterTime(httpResponse.getHeaderString("RetryAfter"));
            httpResponse.close();
            return null;
        }
        ResponseInfo<TResponse, TFaultDetail> responseInfo = new ResponseInfo<TResponse, TFaultDetail>();
        if (statusCodesForApplicationFault.contains(statusCode)) {
            TFaultDetail faultDetail = this.parseStream((InputStream)httpResponse.getEntity(), faultDetailClass);
            responseInfo.setFaultDetail(faultDetail);
            return responseInfo;
        }
        if (statusCode >= 200 && statusCode <= 299) {
            TResponse response = this.parseStream((InputStream)httpResponse.getEntity(), responseClass);
            responseInfo.setResponse(response);
            return responseInfo;
        }
        throw new InternalException("Got unexpected status code " + statusCode + " with response content: " + (String)httpResponse.readEntity(String.class));
    }

    protected String getFaultMessage(String trackingId) {
        return "An error occurred while executing the request. Please check the exception Detail property for more information. TrackingId: " + trackingId;
    }

    protected <T> T parseStream(InputStream stream, Class<T> resultClass) {
        try {
            Object object = AdaptorUtil.mapper.readValue(AdaptorUtil.mapper.getFactory().createParser(stream), resultClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
    }

    protected <TRequest, TResponse, TFaultDetail> jakarta.xml.ws.Response<TResponse> processRequestAsync(final TRequest request, String entityEndpoint, String verb, final Class<TResponse> respClass, final Class<TFaultDetail> faultDetailClass, final Function<TFaultDetail, Exception> getException, final BiFunction<TRequest, AsyncHandler<TResponse>, Future<?>> soapMethod, AsyncHandler<TResponse> handler) {
        String jsonRequest;
        Calendar retryAfterTime;
        final ResponseFuture<TResponse> responseFuture = new ResponseFuture<TResponse>();
        if (handler != null) {
            responseFuture.setHandler(handler);
        }
        if ((retryAfterTime = retryAfter.get(this.serviceInterface)) != null && Calendar.getInstance().before(retryAfterTime)) {
            soapMethod.apply(request, new AsyncHandler<TResponse>(){

                public void handleResponse(jakarta.xml.ws.Response<TResponse> soapResponse) {
                    try {
                        responseFuture.setContext(soapResponse.getContext());
                        responseFuture.setResult(soapResponse.get());
                    }
                    catch (Throwable e) {
                        responseFuture.setException(e);
                    }
                }
            });
            return responseFuture;
        }
        try {
            jsonRequest = AdaptorUtil.mapper.writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            throw new InternalException(e);
        }
        InvocationCallback<Response> invocationCallback = new InvocationCallback<Response>(){

            public void completed(Response httpResponse) {
                try {
                    int statusCode = httpResponse.getStatus();
                    if (statusCodesForSwitchToSoap.contains(statusCode) && RestfulServiceClient.this.enableFallbackToSoap) {
                        httpResponse.close();
                        RestfulServiceClient.this.SetRetryAfterTime(httpResponse.getHeaderString("RetryAfter"));
                        soapMethod.apply(request, new AsyncHandler<TResponse>(){

                            public void handleResponse(jakarta.xml.ws.Response<TResponse> soapResponse) {
                                try {
                                    responseFuture.setContext(soapResponse.getContext());
                                    responseFuture.setResult(soapResponse.get());
                                }
                                catch (Throwable e) {
                                    responseFuture.setException(e);
                                }
                            }
                        });
                        return;
                    }
                    String trackingIdHeader = httpResponse.getHeaderString(ServiceUtils.TRACKING_HEADER_NAME);
                    if (statusCodesForApplicationFault.contains(statusCode)) {
                        Object faultDetail = RestfulServiceClient.this.parseStream((InputStream)httpResponse.readEntity(InputStream.class), faultDetailClass);
                        Exception exception = (Exception)getException.apply(faultDetail);
                        responseFuture.setException(exception);
                        return;
                    }
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put(ServiceUtils.TRACKING_KEY, trackingIdHeader);
                    responseFuture.setContext(context);
                    if (statusCode >= 200 && statusCode <= 299) {
                        Object responseObj = RestfulServiceClient.this.parseStream((InputStream)httpResponse.readEntity(InputStream.class), respClass);
                        responseFuture.setResult(responseObj);
                        return;
                    }
                    throw new InternalException("Got unexpected status code " + statusCode + " with response content: " + (String)httpResponse.readEntity(String.class));
                }
                catch (Throwable e) {
                    responseFuture.setException(e);
                    return;
                }
            }

            public void failed(Throwable throwable) {
                responseFuture.setException(throwable);
            }
        };
        AsyncInvoker asyncInvoker = this.createRequestBuilder(entityEndpoint).async();
        switch (verb) {
            case "POST": {
                asyncInvoker.post(Entity.json((Object)jsonRequest), (InvocationCallback)invocationCallback);
                break;
            }
            case "PUT": {
                asyncInvoker.put(Entity.json((Object)jsonRequest), (InvocationCallback)invocationCallback);
                break;
            }
            case "DELETE": {
                asyncInvoker.method(HttpDelete, Entity.json((Object)jsonRequest), (InvocationCallback)invocationCallback);
                break;
            }
            default: {
                throw new InternalException("Unknown HTTP verb: " + verb);
            }
        }
        return responseFuture;
    }

    static {
        AddMixInForArrayOfTypes.AddMixInForArrayOfTypes();
        AddMixInForEnumTypes.AddMixInForEnumTypes();
        AddMixInForComplexTypesWithEnumList.AddMixInForComplexTypesWithEnumList();
        com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.polymorphicTypes.AddMixInForPolymorphicTypes.AddMixInForPolymorphicTypes();
        com.microsoft.bingads.internal.restful.adaptor.generated.bulk.arrayOfTypes.AddMixInForArrayOfTypes.AddMixInForArrayOfTypes();
        com.microsoft.bingads.internal.restful.adaptor.generated.bulk.enums.AddMixInForEnumTypes.AddMixInForEnumTypes();
        com.microsoft.bingads.internal.restful.adaptor.generated.bulk.enums.AddMixInForComplexTypesWithEnumList.AddMixInForComplexTypesWithEnumList();
        com.microsoft.bingads.internal.restful.adaptor.generated.bulk.polymorphicTypes.AddMixInForPolymorphicTypes.AddMixInForPolymorphicTypes();
        com.microsoft.bingads.internal.restful.adaptor.generated.reporting.arrayOfTypes.AddMixInForArrayOfTypes.AddMixInForArrayOfTypes();
        com.microsoft.bingads.internal.restful.adaptor.generated.reporting.enums.AddMixInForEnumTypes.AddMixInForEnumTypes();
        com.microsoft.bingads.internal.restful.adaptor.generated.reporting.enums.AddMixInForComplexTypesWithEnumList.AddMixInForComplexTypesWithEnumList();
        AddMixInForPolymorphicTypes.AddMixInForPolymorphicTypes();
    }

    static class ResponseFuture<T>
    extends ResultFuture<T>
    implements jakarta.xml.ws.Response<T> {
        private Map<String, Object> context = null;

        public ResponseFuture() {
            super(null);
        }

        public void setHandler(final AsyncHandler<T> handler) {
            this.handler = new AsyncCallback<T>(){

                @Override
                public void onCompleted(final Future<T> result) {
                    handler.handleResponse(new jakarta.xml.ws.Response<T>(){

                        public boolean cancel(boolean mayInterruptIfRunning) {
                            return result.cancel(mayInterruptIfRunning);
                        }

                        public boolean isCancelled() {
                            return result.isCancelled();
                        }

                        public boolean isDone() {
                            return result.isDone();
                        }

                        public T get() throws InterruptedException, ExecutionException {
                            return result.get();
                        }

                        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                            return result.get(timeout, unit);
                        }

                        public Map<String, Object> getContext() {
                            return context;
                        }
                    });
                }
            };
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        void setContext(Map<String, Object> context) {
            this.context = context;
        }
    }
}

