/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.internal.ServiceInfo;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.restful.HttpDeleteWithBody;
import com.microsoft.bingads.internal.restful.RestfulServiceClientExtension;
import com.microsoft.bingads.internal.restful.adaptor.AdaptorUtil;
import com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.arrayOfTypes.AddMixInForArrayOfTypes;
import com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.enums.AddMixInForComplexTypesWithEnumList;
import com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.enums.AddMixInForEnumTypes;
import com.microsoft.bingads.internal.restful.adaptor.generated.reporting.polymorphicTypes.AddMixInForPolymorphicTypes;
import com.microsoft.bingads.v13.adinsight.IAdInsightService;
import com.microsoft.bingads.v13.bulk.IBulkService;
import com.microsoft.bingads.v13.campaignmanagement.ICampaignManagementService;
import com.microsoft.bingads.v13.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.v13.customermanagement.ICustomerManagementService;
import com.microsoft.bingads.v13.reporting.IReportingService;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;

public class RestfulServiceClient
extends RestfulServiceClientExtension {
    protected static final String HttpPost = "POST";
    protected static final String HttpPut = "PUT";
    protected static final String HttpDelete = "DELETE";
    protected AuthorizationData authorizationData;
    protected ApiEnvironment environment;
    protected Object soapService;
    private Class serviceInterface;
    private ConcurrentHashMap<Class, Calendar> retryAfter = new ConcurrentHashMap();
    private ArrayList<Integer> statusCodesForApplicationFault = new ArrayList<Integer>(Arrays.asList(400, 401, 403, 429, 500));
    private ArrayList<Integer> statusCodesForSwitchToSoap = new ArrayList<Integer>(Arrays.asList(404, 501));
    private CloseableHttpAsyncClient asyncClient = HttpAsyncClients.createDefault();
    private CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setConnectionManagerShared(true).build();
    private String userAgent;
    private boolean enableFallbackToSoap;
    private static final Map<Class, String> serviceNameAndVersion = new HashMap<Class, String>(){
        {
            this.put(ICustomerBillingService.class, "/Billing/v13");
            this.put(ICustomerManagementService.class, "/CustomerManagement/v13");
            this.put(IReportingService.class, "/Reporting/v13");
            this.put(ICampaignManagementService.class, "/CampaignManagement/v13");
            this.put(IAdInsightService.class, "/AdInsight/v13");
            this.put(IBulkService.class, "/Bulk/v13");
        }
    };
    private static final Map<Class, ServiceInfo> endpoints = new HashMap<Class, ServiceInfo>(){
        {
            this.put(ICustomerBillingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/Billing/v13");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/Billing/v13");
                }
            });
            this.put(ICustomerManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://clientcenter.api.bingads.microsoft.com/CustomerManagement/v13");
                    this.setSandboxUrl("https://clientcenter.api.sandbox.bingads.microsoft.com/CustomerManagement/v13");
                }
            });
            this.put(IReportingService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://reporting.api.bingads.microsoft.com/Reporting/v13");
                    this.setSandboxUrl("https://reporting.api.sandbox.bingads.microsoft.com/Reporting/v13");
                }
            });
            this.put(ICampaignManagementService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://campaign.api.bingads.microsoft.com/CampaignManagement/v13");
                    this.setSandboxUrl("https://campaign.api.sandbox.bingads.microsoft.com/CampaignManagement/v13");
                }
            });
            this.put(IAdInsightService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://adinsight.api.bingads.microsoft.com/AdInsight/v13");
                    this.setSandboxUrl("https://adinsight.api.sandbox.bingads.microsoft.com/AdInsight/v13");
                }
            });
            this.put(IBulkService.class, new ServiceInfo(){
                {
                    this.setProductionUrl("https://bulk.api.bingads.microsoft.com/Bulk/v13");
                    this.setSandboxUrl("https://bulk.api.sandbox.bingads.microsoft.com/Bulk/v13");
                }
            });
        }
    };

    protected RestfulServiceClient(AuthorizationData authData, ApiEnvironment env, Class serviceInterface) {
        this.authorizationData = authData;
        this.environment = env;
        this.serviceInterface = serviceInterface;
        this.enableFallbackToSoap = ServiceUtils.getFallbackFlag();
        this.userAgent = ServiceUtils.getUserAgent();
        switch (serviceInterface.getSimpleName()) {
            case "ICampaignManagementService": {
                AddMixInForArrayOfTypes.AddMixInForArrayOfTypes();
                AddMixInForEnumTypes.AddMixInForEnumTypes();
                AddMixInForComplexTypesWithEnumList.AddMixInForComplexTypesWithEnumList();
                com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.polymorphicTypes.AddMixInForPolymorphicTypes.AddMixInForPolymorphicTypes();
            }
            case "IBulkService": {
                com.microsoft.bingads.internal.restful.adaptor.generated.bulk.arrayOfTypes.AddMixInForArrayOfTypes.AddMixInForArrayOfTypes();
                com.microsoft.bingads.internal.restful.adaptor.generated.bulk.enums.AddMixInForEnumTypes.AddMixInForEnumTypes();
                com.microsoft.bingads.internal.restful.adaptor.generated.bulk.enums.AddMixInForComplexTypesWithEnumList.AddMixInForComplexTypesWithEnumList();
                com.microsoft.bingads.internal.restful.adaptor.generated.bulk.polymorphicTypes.AddMixInForPolymorphicTypes.AddMixInForPolymorphicTypes();
            }
            case "IReportingService": {
                com.microsoft.bingads.internal.restful.adaptor.generated.reporting.arrayOfTypes.AddMixInForArrayOfTypes.AddMixInForArrayOfTypes();
                com.microsoft.bingads.internal.restful.adaptor.generated.reporting.enums.AddMixInForEnumTypes.AddMixInForEnumTypes();
                com.microsoft.bingads.internal.restful.adaptor.generated.reporting.enums.AddMixInForComplexTypesWithEnumList.AddMixInForComplexTypesWithEnumList();
                AddMixInForPolymorphicTypes.AddMixInForPolymorphicTypes();
            }
        }
    }

    public void setSoapService(Object soapService) {
        this.soapService = soapService;
    }

    private String getServiceUrl(String entityEndpoint) {
        String serviceUrl = ServiceUtils.getServiceUrlFromConfig(this.serviceInterface);
        if (serviceUrl == null) {
            ServiceInfo serviceInfo = endpoints.get(this.serviceInterface);
            serviceUrl = serviceInfo.GetUrl(this.environment);
        } else {
            URI uri = URI.create(serviceUrl);
            serviceUrl = "https://" + uri.getAuthority() + serviceNameAndVersion.get(this.serviceInterface);
        }
        return serviceUrl + entityEndpoint;
    }

    private List<String> buildHeaders() {
        final ArrayList<String> headers = new ArrayList<String>();
        headers.add("ApplicationToken");
        headers.add(this.authorizationData.getDeveloperToken());
        headers.add("CustomerId");
        headers.add(Long.toString(this.authorizationData.getCustomerId()));
        headers.add("CustomerAccountId");
        headers.add(Long.toString(this.authorizationData.getAccountId()));
        headers.add("DeveloperToken");
        headers.add(this.authorizationData.getDeveloperToken());
        this.authorizationData.getAuthentication().addHeaders(new HeadersImpl(){

            @Override
            public void addHeader(String name, String value) {
                headers.add(name);
                headers.add(value);
            }
        });
        this.addUserAgent(headers);
        return headers;
    }

    private <T> void addUserAgent(List<String> headers) {
        String javaVersion;
        String actualUserAgent = "BingAdsSDKJava.RestApi";
        if (this.userAgent != null) {
            actualUserAgent = actualUserAgent + "." + this.userAgent;
        }
        if ((javaVersion = System.getProperty("java.version")).matches("\\d+[\\d|\\.|\\_]*\\d+")) {
            actualUserAgent = actualUserAgent + "/" + javaVersion;
        }
        headers.add("User-Agent");
        headers.add(actualUserAgent);
    }

    private <Req, Resp> Resp callSoapMethod(Req request) throws Exception {
        Object response = null;
        String[] strs = request.getClass().getName().split("\\.");
        String methodName = strs[strs.length - 1];
        methodName = methodName.substring(0, 1).toLowerCase() + methodName.substring(1, methodName.length() - 7);
        try {
            Method method = this.soapService.getClass().getMethod(methodName, request.getClass());
            response = method.invoke(this.soapService, request);
        }
        catch (Exception e) {
            throw (Exception)e.getCause();
        }
        return (Resp)response;
    }

    private <Req, Resp> Response<Resp> callSoapMethodAsync(Req request) {
        Response response = null;
        String[] strs = request.getClass().getName().split("\\.");
        String methodName = strs[strs.length - 1];
        methodName = methodName.substring(0, 1).toLowerCase() + methodName.substring(1, methodName.length() - 7) + "Async";
        try {
            Method method = this.soapService.getClass().getMethod(methodName, request.getClass());
            response = (Response)method.invoke(this.soapService, request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private HttpEntityEnclosingRequestBase asRequest(String request, String verb, String entityEndpoint) throws Exception {
        Object req = null;
        URI uri = new URI(this.getServiceUrl(entityEndpoint));
        StringEntity entity = new StringEntity(request, ContentType.APPLICATION_JSON);
        List<String> headers = this.buildHeaders();
        switch (verb) {
            case "POST": {
                req = new HttpPost(uri);
                req.setEntity((HttpEntity)entity);
                break;
            }
            case "PUT": {
                req = new HttpPut(uri);
                req.setEntity((HttpEntity)entity);
                break;
            }
            case "DELETE": {
                req = new HttpDeleteWithBody(uri);
                req.setEntity((HttpEntity)entity);
            }
        }
        if (req != null) {
            for (int i = 0; i < headers.size(); i += 2) {
                req.setHeader(headers.get(i), headers.get(i + 1));
            }
        }
        return req;
    }

    private void SetRetryAfterTime(Header header) {
        int delta;
        String value = header != null ? header.getValue() : null;
        try {
            delta = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            delta = 3600;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(13, delta);
        this.retryAfter.put(this.serviceInterface, cal);
    }

    protected <Req, Resp> Resp sendRequest(Req request, String entityEndpoint, String verb, Class respClass) throws Exception {
        if (this.retryAfter.get(this.serviceInterface) != null && this.enableFallbackToSoap && Calendar.getInstance().before(this.retryAfter.get(this.serviceInterface))) {
            return this.callSoapMethod(request);
        }
        String jsonRequest = AdaptorUtil.mapper.writeValueAsString(request);
        String[] headers = this.buildHeaders().toArray(new String[0]);
        HttpEntityEnclosingRequestBase req = this.asRequest(jsonRequest, verb, entityEndpoint);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)req);
        int statusCode = response.getStatusLine().getStatusCode();
        Header header = response.getFirstHeader("Retry-After");
        if (this.statusCodesForSwitchToSoap.contains(statusCode)) {
            this.SetRetryAfterTime(header);
        }
        if (this.statusCodesForApplicationFault.contains(statusCode)) {
            this.throwException(this.serviceInterface.getName().replace(this.serviceInterface.getSimpleName(), ""), (HttpResponse)response);
        }
        if (this.statusCodesForSwitchToSoap.contains(statusCode) && this.enableFallbackToSoap) {
            return this.callSoapMethod(request);
        }
        Object resp = AdaptorUtil.mapper.readValue(AdaptorUtil.mapper.getFactory().createParser(response.getEntity().getContent()), respClass);
        response.close();
        this.httpClient.close();
        return (Resp)resp;
    }

    protected <Req, Resp> Future<?> sendRequestAsync(Req request, String entityEndpoint, String verb, Class respClass, AsyncHandler<Resp> asyncHandler) throws URISyntaxException, IOException, InterruptedException {
        Response<Resp> resp = this.sendRequestAsync(request, entityEndpoint, verb, respClass);
        asyncHandler.handleResponse(resp);
        return resp;
    }

    protected <Req, Resp> Response<Resp> sendRequestAsync(final Req request, String entityEndpoint, String verb, final Class respClass) throws URISyntaxException, IOException, InterruptedException {
        if (this.retryAfter.get(this.serviceInterface) != null && this.enableFallbackToSoap && Calendar.getInstance().before(this.retryAfter.get(this.serviceInterface))) {
            return this.callSoapMethodAsync(request);
        }
        String jsonRequest = AdaptorUtil.mapper.writeValueAsString(request);
        HttpEntityEnclosingRequestBase req = null;
        try {
            req = this.asRequest(jsonRequest, verb, entityEndpoint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.asyncClient.start();
        final Future future = this.asyncClient.execute((HttpUriRequest)req, null);
        return new Response<Resp>(){
            private final Map<String, Object> context = new HashMap<String, Object>();

            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            public boolean isCancelled() {
                return future.isCancelled();
            }

            public boolean isDone() {
                return future.isDone();
            }

            public Resp get() throws InterruptedException, ExecutionException {
                HttpResponse resp = null;
                try {
                    resp = (HttpResponse)future.get();
                }
                catch (InterruptedException e) {
                    System.out.println(e.getCause());
                }
                int statusCode = resp.getStatusLine().getStatusCode();
                Header header = resp.getFirstHeader("RetryAfter");
                if (RestfulServiceClient.this.statusCodesForSwitchToSoap.contains(statusCode)) {
                    RestfulServiceClient.this.SetRetryAfterTime(header);
                }
                Header trackingIdHeader = resp.getFirstHeader(ServiceUtils.TRACKING_HEADER_NAME);
                this.context.put(ServiceUtils.TRACKING_KEY, trackingIdHeader.getValue());
                if (RestfulServiceClient.this.statusCodesForSwitchToSoap.contains(statusCode) && RestfulServiceClient.this.enableFallbackToSoap) {
                    try {
                        Response response = RestfulServiceClient.this.callSoapMethodAsync(request);
                        return response.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (RestfulServiceClient.this.statusCodesForApplicationFault.contains(statusCode)) {
                    RestfulServiceClient.this.throwExecutionException(RestfulServiceClient.this.serviceInterface.getName().replace(RestfulServiceClient.this.serviceInterface.getSimpleName(), ""), resp);
                }
                try {
                    return AdaptorUtil.mapper.readValue(AdaptorUtil.mapper.getFactory().createParser(resp.getEntity().getContent()), respClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public Resp get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                HttpResponse resp = (HttpResponse)future.get(timeout, unit);
                int statusCode = resp.getStatusLine().getStatusCode();
                Header header = resp.getFirstHeader("RetryAfter");
                if (RestfulServiceClient.this.statusCodesForSwitchToSoap.contains(statusCode)) {
                    RestfulServiceClient.this.SetRetryAfterTime(header);
                }
                if (RestfulServiceClient.this.statusCodesForSwitchToSoap.contains(statusCode) && RestfulServiceClient.this.enableFallbackToSoap) {
                    try {
                        Response response = RestfulServiceClient.this.callSoapMethodAsync(request);
                        return response.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (RestfulServiceClient.this.statusCodesForApplicationFault.contains(statusCode)) {
                    RestfulServiceClient.this.throwExecutionException(RestfulServiceClient.this.serviceInterface.getName().replace(RestfulServiceClient.this.serviceInterface.getSimpleName(), ""), resp);
                }
                try {
                    return AdaptorUtil.mapper.readValue(AdaptorUtil.mapper.getFactory().createParser(resp.getEntity().getContent()), respClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public Map<String, Object> getContext() {
                return this.context;
            }
        };
    }
}

