/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.internal.WebServiceCaller;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

class HttpClientWebServiceCaller
implements WebServiceCaller {
    private CloseableHttpClient client;

    HttpClientWebServiceCaller() {
    }

    @Override
    public HttpResponse post(URL requestUrl, List<NameValuePair> formValues) throws IOException {
        try {
            this.client = this.createHttpClientWithProxy();
            HttpPost httpPost = new HttpPost(requestUrl.toURI());
            UrlEncodedFormEntity requestEntity = new UrlEncodedFormEntity(formValues, "UTF-8");
            httpPost.setEntity((HttpEntity)requestEntity);
            return this.client.execute((HttpUriRequest)httpPost);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private CloseableHttpClient createHttpClientWithProxy() {
        int timeout = 300000;
        try {
            String strTimeout = System.getProperty("sun.net.client.defaultConnectTimeout", "300000");
            timeout = Integer.parseInt(strTimeout);
        }
        catch (Exception e) {
            timeout = 300000;
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        CloseableHttpClient client = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).setDefaultRequestConfig(config).build();
        return client;
    }

    @Override
    public void shutDown() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

