/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.RestfulServiceFactory;
import com.microsoft.bingads.internal.HeaderHandler;
import com.microsoft.bingads.internal.MessageHandler;
import com.microsoft.bingads.internal.OAuthWithAuthorizationCode;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceFactoryFactory;
import com.microsoft.bingads.internal.ServiceUtils;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import jakarta.jws.WebService;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.PortInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class ServiceClient<T> {
    private static Logger logger = Logger.getLogger(ServiceClient.class.getName());
    private final AuthorizationData authorizationData;
    private final Class<T> serviceInterface;
    private final Service service;
    private final ServiceFactory serviceFactory;
    private ApiEnvironment environment;
    private RestfulServiceClient restService;

    public ApiEnvironment getEnvironment() {
        return this.environment;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public ServiceClient(AuthorizationData authorizationData, Class<T> serviceInterface) {
        this(authorizationData, null, serviceInterface, false);
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface) {
        this(authorizationData, environment, serviceInterface, false);
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface, boolean enableRestApi) {
        this.authorizationData = authorizationData;
        this.serviceInterface = serviceInterface;
        if (environment == null && authorizationData.getAuthentication() != null) {
            environment = authorizationData.getAuthentication().getEnvironment();
        }
        if (environment == null) {
            environment = ServiceUtils.getEnvironmentFromConfig();
        }
        if (environment == null) {
            environment = ApiEnvironment.PRODUCTION;
        }
        this.environment = environment;
        this.serviceFactory = ServiceFactoryFactory.createServiceFactory();
        this.service = this.serviceFactory.createService(serviceInterface, environment);
        if (enableRestApi) {
            this.restService = RestfulServiceFactory.createServiceClient(authorizationData, environment, serviceInterface);
        }
    }

    public T getService() {
        this.authorizationData.validate();
        WebService webServiceAnnotation = this.serviceInterface.getAnnotation(WebService.class);
        final String ns = webServiceAnnotation.targetNamespace();
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CustomerAccountId", Long.toString(this.authorizationData.getAccountId()));
        headers.put("CustomerId", Long.toString(this.authorizationData.getCustomerId()));
        headers.put("DeveloperToken", this.authorizationData.getDeveloperToken());
        this.refreshOAuthTokensIfNeeded();
        this.authorizationData.getAuthentication().addHeaders(new HeadersImpl(){

            @Override
            public void addHeader(String name, String value) {
                headers.put(name, value);
            }
        });
        this.service.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new HeaderHandler(ns, headers));
                handlerList.add((Handler)MessageHandler.getInstance());
                return handlerList;
            }
        });
        T port = this.serviceFactory.createProxyFromService(this.service, this.environment, this.serviceInterface);
        if (this.restService == null) {
            return port;
        }
        this.restService.setSoapService(port);
        return (T)Proxy.newProxyInstance(port.getClass().getClassLoader(), port.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                Method delegationMethod = ServiceClient.this.restService.getClass().getMethod(methodName, method.getParameterTypes());
                Object response = null;
                try {
                    response = delegationMethod.invoke((Object)ServiceClient.this.restService, args);
                }
                catch (Exception e) {
                    throw e.getCause();
                }
                return response;
            }
        });
    }

    private void refreshOAuthTokensIfNeeded() {
        if (this.authorizationData.getAuthentication() instanceof OAuthWithAuthorizationCode) {
            OAuthWithAuthorizationCode auth = (OAuthWithAuthorizationCode)this.authorizationData.getAuthentication();
            auth.refreshTokensIfNeeded(false);
        }
    }
}

