/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.AdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.ProductCondition;
import com.microsoft.bingads.v13.campaignmanagement.ProductPartition;
import com.microsoft.bingads.v13.campaignmanagement.ProductPartitionType;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupProductPartition
extends BulkAdGroupCriterion {
    private static final List<BulkMapping<BulkAdGroupProductPartition>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdGroupCriterion(), AdGroupCriterion.class.getSimpleName());
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public Criterion createCriterion() {
        ProductPartition productPartition = new ProductPartition();
        productPartition.setCondition(new ProductCondition());
        productPartition.setType(ProductPartition.class.getSimpleName());
        return productPartition;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupProductPartition, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupProductPartition, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Sub Type", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    ProductPartitionType productPartitionType = ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getPartitionType();
                    return productPartitionType == null ? null : productPartitionType.value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).setPartitionType(StringExtensions.parseOptional(v, new Function<String, ProductPartitionType>(){

                    @Override
                    public ProductPartitionType apply(String s) {
                        return ProductPartitionType.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, Long>("Parent Criterion Id", new Function<BulkAdGroupProductPartition, Long>(){

            @Override
            public Long apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    return ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getParentCriterionId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).setParentCriterionId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Product Condition 1", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    ProductCondition productCondition = ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition();
                    return productCondition == null ? null : productCondition.getOperand();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition().setOperand(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Product Value 1", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion().getCriterion() instanceof ProductPartition) {
                    ProductCondition productCondition = ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition();
                    return productCondition == null ? null : productCondition.getAttribute();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                ((ProductPartition)c.getAdGroupCriterion().getCriterion()).getCondition().setAttribute(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupProductPartition, String>("Destination Url", new Function<BulkAdGroupProductPartition, String>(){

            @Override
            public String apply(BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    return StringExtensions.toOptionalBulkString(((BiddableAdGroupCriterion)c.getAdGroupCriterion()).getDestinationUrl(), c.getAdGroupCriterion().getId());
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupProductPartition>(){

            @Override
            public void accept(String v, BulkAdGroupProductPartition c) {
                if (c.getAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    ((BiddableAdGroupCriterion)c.getAdGroupCriterion()).setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
                }
            }
        }, true));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

