/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAudience;
import com.microsoft.bingads.v13.campaignmanagement.Audience;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCustomerList
extends BulkAudience<Audience> {
    private String actionType;
    private static final List<BulkMapping<BulkCustomerList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public Audience getCustomerList() {
        return this.getAudience();
    }

    public void setCustomerList(Audience CustomerList) {
        this.setAudience(CustomerList);
    }

    @Override
    public Audience createAudience() {
        return new Audience();
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCustomerList, String>> m = new ArrayList<SimpleBulkMapping<BulkCustomerList, String>>();
        m.add(new SimpleBulkMapping<BulkCustomerList, String>("Action Type", new Function<BulkCustomerList, String>(){

            @Override
            public String apply(BulkCustomerList c) {
                return c.getActionType();
            }
        }, new BiConsumer<String, BulkCustomerList>(){

            @Override
            public void accept(String v, BulkCustomerList c) {
                c.setActionType(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

