/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.Audience;
import com.microsoft.bingads.v13.campaignmanagement.EntityScope;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAudience<T extends Audience>
extends SingleRecordBulkEntity {
    private T audience;
    private Status status;
    private static final List<BulkMapping<BulkAudience>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAudience(this.createAudience());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAudience(), "Audience");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public abstract T createAudience();

    public T getAudience() {
        return this.audience;
    }

    public void setAudience(T audience) {
        this.audience = audience;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAudience, Object>> m = new ArrayList<SimpleBulkMapping<BulkAudience, Object>>();
        m.add(new SimpleBulkMapping<BulkAudience, String>("Status", new Function<BulkAudience, String>(){

            @Override
            public String apply(BulkAudience c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, Long>("Id", new Function<BulkAudience, Long>(){

            @Override
            public Long apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getId();
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, Long>("Parent Id", new Function<BulkAudience, Long>(){

            @Override
            public Long apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getParentId();
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setParentId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, String>("Audience", new Function<BulkAudience, String>(){

            @Override
            public String apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getName();
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, Long>("Audience Search Size", new Function<BulkAudience, Long>(){

            @Override
            public Long apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getSearchSize();
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setSearchSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, String>("Description", new Function<BulkAudience, String>(){

            @Override
            public String apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getDescription();
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, Integer>("Membership Duration", new Function<BulkAudience, Integer>(){

            @Override
            public Integer apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getMembershipDuration();
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setMembershipDuration(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, String>("Scope", new Function<BulkAudience, String>(){

            @Override
            public String apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getScope() != null ? ((Audience)c.getAudience()).getScope().value() : null;
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setScope(StringExtensions.parseOptional(v, new Function<String, EntityScope>(){

                    @Override
                    public EntityScope apply(String value) {
                        return EntityScope.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, Long>("Audience Network Size", new Function<BulkAudience, Long>(){

            @Override
            public Long apply(BulkAudience c) {
                return ((Audience)c.getAudience()).getAudienceNetworkSize();
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setAudienceNetworkSize(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAudience, String>("Supported Campaign Types", new Function<BulkAudience, String>(){

            @Override
            public String apply(BulkAudience c) {
                return StringExtensions.writeArrayOfstring(((Audience)c.getAudience()).getSupportedCampaignTypes(), ";");
            }
        }, new BiConsumer<String, BulkAudience>(){

            @Override
            public void accept(String v, BulkAudience c) {
                ((Audience)c.getAudience()).setSupportedCampaignTypes(StringExtensions.parseArrayOfString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

