/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.reporting;

import com.googlecode.jcsv.CSVStrategy;
import com.googlecode.jcsv.reader.CSVEntryParser;
import com.googlecode.jcsv.reader.CSVReader;
import com.googlecode.jcsv.reader.internal.CSVReaderBuilder;
import com.googlecode.jcsv.reader.internal.DefaultCSVEntryParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

class CsvReportRecordReader
implements Iterable<String[]>,
AutoCloseable {
    private CSVReader<String[]> csvReader;

    CsvReportRecordReader(BufferedReader reader, char delimiter) {
        this.csvReader = CsvReportRecordReader.buildCSVReader(reader, delimiter);
    }

    @Override
    public void close() throws IOException {
        this.csvReader.close();
    }

    @Override
    public Iterator<String[]> iterator() {
        return this.csvReader.iterator();
    }

    private static CSVReader<String[]> buildCSVReader(Reader reader, char delimiter) {
        try {
            reader.mark(1);
            int read = reader.read();
            if (read != 65279) {
                reader.reset();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CSVReaderBuilder(reader).entryParser((CSVEntryParser)new DefaultCSVEntryParser()).strategy(CsvReportRecordReader.createStrategyWithDelimiter(delimiter)).build();
    }

    private static CSVStrategy createStrategyWithDelimiter(char delimiter) {
        return new CSVStrategy(delimiter, '\"', '#', false, true);
    }
}

