/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.internal.bulk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.LocationTargetType;
import com.microsoft.bingads.v12.bulk.entities.Status;
import com.microsoft.bingads.v12.campaignmanagement.ActionAdExtensionActionType;
import com.microsoft.bingads.v12.campaignmanagement.AdExtensionStatus;
import com.microsoft.bingads.v12.campaignmanagement.AdRotation;
import com.microsoft.bingads.v12.campaignmanagement.AdRotationType;
import com.microsoft.bingads.v12.campaignmanagement.AdStatus;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfAssetLink;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfCustomParameter;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfDayTime;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfRuleItem;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfRuleItemGroup;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOflong;
import com.microsoft.bingads.v12.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v12.campaignmanagement.AssetLink;
import com.microsoft.bingads.v12.campaignmanagement.AssetLinkEditorialStatus;
import com.microsoft.bingads.v12.campaignmanagement.Bid;
import com.microsoft.bingads.v12.campaignmanagement.BiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.BusinessGeoCodeStatus;
import com.microsoft.bingads.v12.campaignmanagement.CriterionBid;
import com.microsoft.bingads.v12.campaignmanagement.CriterionTypeGroup;
import com.microsoft.bingads.v12.campaignmanagement.CustomEventsRule;
import com.microsoft.bingads.v12.campaignmanagement.CustomParameter;
import com.microsoft.bingads.v12.campaignmanagement.CustomParameters;
import com.microsoft.bingads.v12.campaignmanagement.Date;
import com.microsoft.bingads.v12.campaignmanagement.Day;
import com.microsoft.bingads.v12.campaignmanagement.DayTime;
import com.microsoft.bingads.v12.campaignmanagement.EnhancedCpcBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.FixedBid;
import com.microsoft.bingads.v12.campaignmanagement.ImageAsset;
import com.microsoft.bingads.v12.campaignmanagement.InheritFromParentBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.ManualCpcBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.MatchType;
import com.microsoft.bingads.v12.campaignmanagement.MaxClicksBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.MaxConversionsBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.Minute;
import com.microsoft.bingads.v12.campaignmanagement.NumberOperator;
import com.microsoft.bingads.v12.campaignmanagement.PageVisitorsRule;
import com.microsoft.bingads.v12.campaignmanagement.PageVisitorsWhoDidNotVisitAnotherPageRule;
import com.microsoft.bingads.v12.campaignmanagement.PageVisitorsWhoVisitedAnotherPageRule;
import com.microsoft.bingads.v12.campaignmanagement.ProductAudienceType;
import com.microsoft.bingads.v12.campaignmanagement.RemarketingRule;
import com.microsoft.bingads.v12.campaignmanagement.RuleItem;
import com.microsoft.bingads.v12.campaignmanagement.RuleItemGroup;
import com.microsoft.bingads.v12.campaignmanagement.StringOperator;
import com.microsoft.bingads.v12.campaignmanagement.StringRuleItem;
import com.microsoft.bingads.v12.campaignmanagement.TargetCpaBiddingScheme;
import com.microsoft.bingads.v12.campaignmanagement.TargetSetting;
import com.microsoft.bingads.v12.campaignmanagement.TargetSettingDetail;
import com.microsoft.bingads.v12.campaignmanagement.TextAsset;
import com.microsoft.bingads.v12.campaignmanagement.WebpageParameter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;

public class StringExtensions {
    private static final String UNKNOWN_DEVICE_PREFERENCE = "Unknown device preference";
    private static final String ALL = "All";
    private static final String MOBILE = "Mobile";
    private static final String DATE_OUTPUT_FORMAT = "%d/%d/%d";
    private static final String urlSplitter = ";\\s*(?=https?://)";
    private static final String customParameterSplitter = "(?<!\\\\);\\s*";
    private static final Pattern customKvPattern = Pattern.compile("^\\{_(.*?)\\}=(.*$)");
    private static final Pattern dayTimePattern = Pattern.compile("\\((Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday)\\[(\\d\\d?):(\\d\\d)-(\\d\\d?):(\\d\\d)\\]\\)");
    private static final Pattern targetSettingDetailsPattern = Pattern.compile("^(Age|Audience|CompanyName|Gender|Industry|JobFunction)$");
    private static final Pattern pageRulePattern = Pattern.compile("^(Url|ReferrerUrl|None) (Equals|Contains|BeginsWith|EndsWith|NotEquals|DoesNotContain|DoesNotBeginWith|DoesNotEndWith) ([^()]*)$");
    private static final Pattern operandPattern = Pattern.compile("^(Category|Action|Label|Value) ([^()]*)$");
    private static final Pattern stringOperatorPattern = Pattern.compile("^(Equals|Contains|BeginsWith|EndsWith|NotEquals|DoesNotContain|DoesNotBeginWith|DoesNotEndWith) ([^()]*)$");
    private static final Pattern numberOperatorPattern = Pattern.compile("^(Equals|GreaterThan|LessThan|GreaterThanEqualTo|LessThanEqualTo) ([^()]*)$");
    public static SimpleDateFormat SYNC_TIME_FORMATTER = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public static String toKeywordBidBulkString(Bid bid, Long id) {
        if (bid == null) {
            return null;
        }
        if (bid.getAmount() == null) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        return StringExtensions.toBulkString(bid.getAmount());
    }

    public static String toBidBulkString(Bid bid, Long id) {
        if (bid == null) {
            return null;
        }
        if (bid.getAmount() == null) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        return StringExtensions.toBulkString(bid.getAmount());
    }

    public static Long nullOrLong(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BigDecimal nullOrBigDecimal(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return BigDecimal.valueOf(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static <T> String toBulkString(T value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Double nullOrDouble(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer parseOptionalInteger(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static int parseInt(String value) {
        return Integer.parseInt(value);
    }

    public static Date parseDate(String headerValue) throws ParseException {
        if (headerValue == null || headerValue.length() == 0) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        format.setLenient(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(format.parse(headerValue));
        Date bingDate = new Date();
        bingDate.setDay(calendar.get(5));
        bingDate.setMonth(calendar.get(2) + 1);
        bingDate.setYear(calendar.get(1));
        return bingDate;
    }

    public static Bid parseAdGroupBid(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Bid bid = new Bid();
        if (v.equals("delete_value")) {
            bid.setAmount(0.0);
            return bid;
        }
        Double bidAmount = StringExtensions.nullOrDouble(v);
        if (bidAmount != null) {
            bid.setAmount(bidAmount);
            return bid;
        }
        return null;
    }

    public static Double parseAdGroupFixedBid(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        if (v.equals("delete_value")) {
            return 0.0;
        }
        return Double.parseDouble(v);
    }

    public static Bid parseAdGroupCriterionBid(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Bid bid = new Bid();
        Double bidAmount = StringExtensions.nullOrDouble(v);
        if (bidAmount != null) {
            bid.setAmount(bidAmount);
            return bid;
        }
        return null;
    }

    public static Bid parseKeywordBid(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Bid bid = new Bid();
        if (v.equals("delete_value")) {
            bid.setAmount(null);
            return bid;
        }
        Double bidAmount = StringExtensions.nullOrDouble(v);
        if (bidAmount != null) {
            bid.setAmount(bidAmount);
            return bid;
        }
        return null;
    }

    public static Bid parseBid(String v) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        Bid bid = new Bid();
        if (v.equals("delete_value")) {
            bid.setAmount(null);
            return bid;
        }
        Double bidAmount = StringExtensions.nullOrDouble(v);
        if (bidAmount != null) {
            bid.setAmount(bidAmount);
            return bid;
        }
        return null;
    }

    public static java.util.Date parseSyncTime(String v) throws ParseException {
        if (v == null || v.isEmpty()) {
            return null;
        }
        return SYNC_TIME_FORMATTER.parse(v);
    }

    public static String toDateBulkString(Date c) {
        if (c == null) {
            return null;
        }
        return String.format(DATE_OUTPUT_FORMAT, c.getMonth(), c.getDay(), c.getYear());
    }

    public static String toScheduleDateBulkString(Date c, Long id) {
        if (c == null || c.getMonth() == 0 && c.getDay() == 0 && c.getYear() == 0) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        return String.format(DATE_OUTPUT_FORMAT, c.getMonth(), c.getDay(), c.getYear());
    }

    public static AdRotation parseAdRotation(String v) {
        if ("delete_value".equals(v)) {
            return null;
        }
        if (v == null || v.isEmpty()) {
            return null;
        }
        try {
            AdRotation rotation = new AdRotation();
            rotation.setType(AdRotationType.fromValue(v));
            return rotation;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isTurnedOn(String v) {
        return v != null && v.length() != 0 && !"delete_value".equals(v) && v.equals("On");
    }

    public static <T> T parseOptionalUpperCase(String v, Function<String, T> parse) {
        if (v == null | v.length() == 0) {
            return null;
        }
        return StringExtensions.parseOptional(v.substring(0, 1) + v.substring(1, v.length()).toLowerCase(), parse);
    }

    public static <T> T parseOptional(String v, Function<String, T> parse) {
        if (v == null || v.length() == 0) {
            return null;
        }
        return parse.apply(v);
    }

    public static <T> JAXBElement<T> parseJAXBElement(String v, Function<String, T> parse, Function<T, JAXBElement<T>> factory) {
        if (v == null || v.length() == 0) {
            return null;
        }
        return factory.apply(parse.apply(v));
    }

    public static String toOptionalBulkString(String value, Long id) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty() && id != null && id > 0L) {
            return "delete_value";
        }
        return value;
    }

    public static String getValueOrEmptyString(String v) {
        if (v == null || v.isEmpty() || v.equals("delete_value")) {
            return "";
        }
        return v;
    }

    public static Long parseDevicePreference(String v) {
        if (v == null || v.isEmpty() || v.equals(ALL)) {
            return 0L;
        }
        if (v.equals(MOBILE)) {
            return 30001L;
        }
        throw new UnsupportedOperationException(UNKNOWN_DEVICE_PREFERENCE);
    }

    public static String toDevicePreferenceBulkString(Long pref) {
        if (pref == null || pref.equals(0L)) {
            return ALL;
        }
        if (pref.equals(30001L)) {
            return MOBILE;
        }
        throw new UnsupportedOperationException(UNKNOWN_DEVICE_PREFERENCE);
    }

    public static <T> T parse(String v, Function<String, T> parser) {
        return parser.apply(v);
    }

    public static String toMatchTypeBulkString(MatchType type) {
        if (type == null) {
            return null;
        }
        return type.value();
    }

    public static String toAdRotationBulkString(AdRotation c) {
        if (c == null || c.getType() == null) {
            return null;
        }
        return StringExtensions.toBulkString(c.getType().value());
    }

    public static String toAdGroupBidBulkString(Bid bid, Long id) {
        if (bid == null || bid.getAmount() == null) {
            return null;
        }
        if (bid.getAmount() == 0.0) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        return bid.getAmount().toString();
    }

    public static String toCriterionBidMultiplierBulkString(Double v) {
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public static String toAdGroupFixedBidBulkString(FixedBid bid, Long id) {
        if (bid == null || bid.getAmount() == null) {
            return null;
        }
        if (bid.getAmount() == 0.0) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        return bid.getAmount().toString();
    }

    public static String toAdGroupCriterionBidBulkString(Bid bid) {
        if (bid == null || bid.getAmount() == null) {
            return null;
        }
        return bid.getAmount().toString();
    }

    public static String toAdGroupCriterionFixedBidBulkString(FixedBid bid) {
        if (bid == null || bid.getAmount() == null) {
            return null;
        }
        return bid.getAmount().toString();
    }

    public static CriterionBid parseFixedAdGroupBid(String v) {
        Bid bid = StringExtensions.parseAdGroupBid(v);
        if (bid == null) {
            return null;
        }
        FixedBid fixedBid = new FixedBid();
        fixedBid.setAmount(bid.getAmount());
        return fixedBid;
    }

    public static String toAdStatusBulkString(AdStatus status) {
        if (status == null) {
            return null;
        }
        return status.value();
    }

    public static String toGeoCodeStatusBulkString(BusinessGeoCodeStatus geoCodeStatus) {
        if (geoCodeStatus == null) {
            return null;
        }
        return geoCodeStatus.value();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static Integer parseLatLngInMicroDegrees(String v) {
        Double decimalDegrees = StringExtensions.parseOptional(v, new Function<String, Double>(){

            @Override
            public Double apply(String value) {
                return Double.parseDouble(value);
            }
        });
        if (decimalDegrees == null) {
            return null;
        }
        return (int)Math.round(decimalDegrees * 1000000.0);
    }

    public static String toBooleanBulkString(Boolean isCallOnly) {
        if (isCallOnly == null) {
            return null;
        }
        if (isCallOnly.booleanValue()) {
            return "True";
        }
        return "False";
    }

    public static String toAdExtensionStatusBulkString(AdExtensionStatus status) {
        if (status == null) {
            return null;
        }
        return status.value();
    }

    public static String toStatusBulkString(Status status) {
        if (status == null) {
            return null;
        }
        return status.value();
    }

    public static Minute parseMinute(String s) {
        int minuteNumber = Integer.parseInt(s);
        switch (minuteNumber) {
            case 0: {
                return Minute.ZERO;
            }
            case 15: {
                return Minute.FIFTEEN;
            }
            case 30: {
                return Minute.THIRTY;
            }
            case 45: {
                return Minute.FORTY_FIVE;
            }
        }
        throw new IllegalArgumentException("Unknown minute");
    }

    public static String toMinuteBulkString(Minute minute) {
        switch (minute) {
            case ZERO: {
                return "0";
            }
            case FIFTEEN: {
                return "15";
            }
            case THIRTY: {
                return "30";
            }
            case FORTY_FIVE: {
                return "45";
            }
        }
        throw new IllegalArgumentException("Unknown minute");
    }

    public static Day parseDay(String s) {
        if (s.toLowerCase().equals("sunday")) {
            return Day.SUNDAY;
        }
        if (s.toLowerCase().equals("monday")) {
            return Day.MONDAY;
        }
        if (s.toLowerCase().equals("tuesday")) {
            return Day.TUESDAY;
        }
        if (s.toLowerCase().equals("wednesday")) {
            return Day.WEDNESDAY;
        }
        if (s.toLowerCase().equals("thursday")) {
            return Day.THURSDAY;
        }
        if (s.toLowerCase().equals("friday")) {
            return Day.FRIDAY;
        }
        if (s.toLowerCase().equals("saturday")) {
            return Day.SATURDAY;
        }
        throw new IllegalArgumentException("Unknown day");
    }

    public static LocationTargetType parseLocationTargetType(String s) {
        if (s.equals("Metro Area")) {
            return LocationTargetType.METRO_AREA;
        }
        if (s.equals("Postal Code")) {
            return LocationTargetType.POSTAL_CODE;
        }
        return LocationTargetType.fromValue(s);
    }

    public static String toLocationTargetTypeBulkString(LocationTargetType locationTargetType) {
        if (locationTargetType == null) {
            return null;
        }
        switch (locationTargetType) {
            case METRO_AREA: {
                return "Metro Area";
            }
            case POSTAL_CODE: {
                return "Postal Code";
            }
        }
        return locationTargetType.value();
    }

    public static String join(String separator, List<String> strings) {
        if (strings == null) {
            return null;
        }
        String result = "";
        Integer i = 0;
        while (i < strings.size() - 1) {
            result = result + strings.get(i) + separator;
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result = result + strings.get(strings.size() - 1);
        return result;
    }

    public static String getFileExtension(String fileName) {
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            return fileName.substring(indexOfDot);
        }
        return fileName;
    }

    public static String getFileNameWithoutExtension(File file) {
        String fileName = file.getName();
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            return fileName.substring(0, indexOfDot);
        }
        return fileName;
    }

    public static File changeFileExtension(File file, String newExtension) {
        String fullFileName = file.toString();
        int indexOfDot = fullFileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            return new File(fullFileName.substring(0, indexOfDot) + newExtension);
        }
        return new File(fullFileName + newExtension);
    }

    public static String writeUrls(String separator, ArrayOfstring strings, Long id) {
        if (strings == null) {
            return null;
        }
        if (strings.getStrings().size() == 0) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        StringBuilder result = new StringBuilder("");
        int length = strings.getStrings().size();
        Integer i = 0;
        while (i < length - 1) {
            result.append(strings.getStrings().get(i) + separator);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result.append(strings.getStrings().get(length - 1));
        return result.toString();
    }

    public static List<String> parseUrls(String s) {
        String[] urls;
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        ArrayList<String> urlArray = new ArrayList<String>();
        for (String tmp : urls = s.split(urlSplitter)) {
            if (StringExtensions.isNullOrEmpty(tmp) || ";".equals(tmp)) continue;
            urlArray.add(tmp);
        }
        return urlArray;
    }

    public static String writeCampaignLanguages(String separator, ArrayOfstring strings, Long id) {
        if (strings == null) {
            return null;
        }
        if (strings.getStrings().size() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder("");
        int length = strings.getStrings().size();
        Integer i = 0;
        while (i < length - 1) {
            result.append(strings.getStrings().get(i) + separator);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result.append(strings.getStrings().get(length - 1));
        return result.toString();
    }

    public static List<String> parseCampaignLanguages(String s) {
        String[] languages;
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        ArrayList<String> languageArray = new ArrayList<String>();
        for (String tmp : languages = s.split("[;\\s?]")) {
            if (StringExtensions.isNullOrEmpty(tmp) || ";".equals(tmp)) continue;
            languageArray.add(tmp);
        }
        return languageArray;
    }

    public static String toCustomParaBulkString(CustomParameters parameters, Long id) {
        if (parameters == null) {
            return null;
        }
        ArrayOfCustomParameter customParaArray = parameters.getParameters();
        if (customParaArray == null || customParaArray.getCustomParameters().size() == 0) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        String result = "";
        int length = customParaArray.getCustomParameters().size();
        for (int i = 0; i < length - 1; ++i) {
            CustomParameter cp = customParaArray.getCustomParameters().get(i);
            String tmp = String.format("{_%s}=%s", cp.getKey(), StringExtensions.escapeParameterText(cp.getValue()));
            result = result + tmp + "; ";
        }
        CustomParameter cp = customParaArray.getCustomParameters().get(length - 1);
        result = result + String.format("{_%s}=%s", cp.getKey(), StringExtensions.escapeParameterText(cp.getValue()));
        return result;
    }

    private static String escapeParameterText(String text) {
        StringBuffer buffer = new StringBuffer(text.length() * 2);
        for (char c : text.toCharArray()) {
            if (c == ';' || c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String unEscapeParameterText(String text) {
        StringBuffer buffer = new StringBuffer(text.length());
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) == '\\') {
                ++i;
            }
            if (i >= length) continue;
            buffer.append(text.charAt(i));
        }
        return buffer.toString();
    }

    public static CustomParameters parseCustomParameters(String s) throws Exception {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        String[] parameters = s.split(customParameterSplitter);
        ArrayOfCustomParameter customParametersArray = new ArrayOfCustomParameter();
        for (String p : parameters) {
            if (StringExtensions.isNullOrEmpty(p)) continue;
            Matcher match = customKvPattern.matcher(p = p.trim());
            if (match.find()) {
                CustomParameter param = new CustomParameter();
                param.setKey(match.group(1));
                param.setValue(StringExtensions.unEscapeParameterText(match.group(2)));
                customParametersArray.getCustomParameters().add(param);
                continue;
            }
            throw new IllegalArgumentException(String.format("Bad format for CustomParameters: %s", s));
        }
        CustomParameters result = new CustomParameters();
        result.setParameters(customParametersArray);
        return result;
    }

    public static BiddingScheme parseBiddingScheme(String s) throws Exception {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        BiddingScheme biddingScheme = null;
        if (s.equals("EnhancedCpc")) {
            biddingScheme = new EnhancedCpcBiddingScheme();
            biddingScheme.setType("EnhancedCpc");
        } else if (s.equals("InheritFromParent")) {
            biddingScheme = new InheritFromParentBiddingScheme();
            biddingScheme.setType("InheritFromParent");
        } else if (s.equals("MaxConversions")) {
            biddingScheme = new MaxConversionsBiddingScheme();
            biddingScheme.setType("MaxConversions");
        } else if (s.equals("ManualCpc")) {
            biddingScheme = new ManualCpcBiddingScheme();
            biddingScheme.setType("ManualCpc");
        } else if (s.equals("TargetCpa")) {
            biddingScheme = new TargetCpaBiddingScheme();
            biddingScheme.setType("TargetCpa");
        } else if (s.equals("MaxClicks")) {
            biddingScheme = new MaxClicksBiddingScheme();
            biddingScheme.setType("MaxClicks");
        } else {
            throw new IllegalArgumentException(String.format("Unknown value for Bid Strategy Type : %s", s));
        }
        return biddingScheme;
    }

    public static String toBiddingSchemeBulkString(BiddingScheme biddingScheme) throws Exception {
        if (biddingScheme == null) {
            return null;
        }
        if (biddingScheme instanceof EnhancedCpcBiddingScheme) {
            return "EnhancedCpc";
        }
        if (biddingScheme instanceof InheritFromParentBiddingScheme) {
            return "InheritFromParent";
        }
        if (biddingScheme instanceof MaxConversionsBiddingScheme) {
            return "MaxConversions";
        }
        if (biddingScheme instanceof ManualCpcBiddingScheme) {
            return "ManualCpc";
        }
        if (biddingScheme instanceof TargetCpaBiddingScheme) {
            return "TargetCpa";
        }
        if (biddingScheme instanceof MaxClicksBiddingScheme) {
            return "MaxClicks";
        }
        throw new IllegalArgumentException("Unknown bidding scheme");
    }

    public static String toNativePreferenceBulkString(String parameter) {
        if (StringExtensions.isNullOrEmpty(parameter)) {
            return null;
        }
        return parameter;
    }

    public static List<Long> parseImageMediaIds(String v) {
        String[] ids;
        if (StringExtensions.isNullOrEmpty(v)) {
            return null;
        }
        ArrayList<Long> idArray = new ArrayList<Long>();
        for (String tmp : ids = v.split(";")) {
            if (StringExtensions.isNullOrEmpty(tmp) || ";".equals(tmp)) continue;
            idArray.add(Long.parseLong(tmp));
        }
        return idArray;
    }

    public static String writeMediaIds(String separator, ArrayOflong ids) {
        if (ids == null) {
            return null;
        }
        if (ids.getLongs().size() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder("");
        int length = ids.getLongs().size();
        Integer i = 0;
        while (i < length - 1) {
            result.append(ids.getLongs().get(i) + separator);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result.append(ids.getLongs().get(length - 1));
        return result.toString();
    }

    public static ArrayOfstring parseStructuredSnippetValues(String v) {
        String[] values;
        if (StringExtensions.isNullOrEmpty(v)) {
            return null;
        }
        ArrayOfstring valueArray = new ArrayOfstring();
        for (String tmp : values = v.split(";")) {
            if (StringExtensions.isNullOrEmpty(tmp) || ";".equals(tmp)) continue;
            valueArray.getStrings().add(tmp);
        }
        return valueArray;
    }

    public static String writeStructuredSnippetValues(String separator, ArrayOfstring values) {
        if (values == null || values.getStrings().size() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder("");
        int length = values.getStrings().size();
        Integer i = 0;
        while (i < length - 1) {
            result.append(values.getStrings().get(i) + separator);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        result.append(values.getStrings().get(length - 1));
        return result.toString();
    }

    public static String toDayTimeRangesBulkString(ArrayOfDayTime arrayOfDayTime, Long id) {
        if (arrayOfDayTime == null) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        List<DayTime> dayTimeRanges = arrayOfDayTime.getDayTimes();
        if (dayTimeRanges == null || dayTimeRanges.size() == 0) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        String result = "";
        int length = dayTimeRanges.size();
        for (int i = 0; i < length - 1; ++i) {
            DayTime dayTime = dayTimeRanges.get(i);
            String tmp = String.format(String.format("(%s[%02d:%02d-%02d:%02d])", dayTime.getDay().value(), dayTime.getStartHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getStartMinute())), dayTime.getEndHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getEndMinute()))), new Object[0]);
            result = result + tmp + ";";
        }
        DayTime dayTime = dayTimeRanges.get(length - 1);
        result = result + String.format(String.format("(%s[%02d:%02d-%02d:%02d])", dayTime.getDay().value(), dayTime.getStartHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getStartMinute())), dayTime.getEndHour(), Integer.parseInt(StringExtensions.toMinuteBulkString(dayTime.getEndMinute()))), new Object[0]);
        return result;
    }

    public static ArrayOfDayTime parseDayTimeRanges(String s) {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        String[] parameters = s.split(";");
        ArrayList<DayTime> dayTimeArray = new ArrayList<DayTime>();
        for (String p : parameters) {
            if (StringExtensions.isNullOrEmpty(p)) continue;
            Matcher match = dayTimePattern.matcher(p = p.trim());
            if (match.find()) {
                DayTime dayTime = new DayTime();
                dayTime.setDay(StringExtensions.parseDay(match.group(1)));
                dayTime.setStartHour(Integer.parseInt(match.group(2)));
                dayTime.setStartMinute(StringExtensions.parseMinute(match.group(3)));
                dayTime.setEndHour(Integer.parseInt(match.group(4)));
                dayTime.setEndMinute(StringExtensions.parseMinute(match.group(5)));
                dayTimeArray.add(dayTime);
                continue;
            }
            throw new IllegalArgumentException(String.format("Bad format for DateTimeRanges: %s", s));
        }
        ArrayOfDayTime result = new ArrayOfDayTime();
        result.getDayTimes().addAll(dayTimeArray);
        return result;
    }

    public static String toUseSearcherTimeZoneBulkString(Boolean useSearcherTimeZone) {
        if (useSearcherTimeZone == null) {
            return "false";
        }
        return useSearcherTimeZone != false ? "true" : "false";
    }

    public static Boolean parseUseSearcherTimeZone(String s) {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        if (s.toLowerCase().equals("true")) {
            return true;
        }
        if (s.toLowerCase().equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Unknown value for Use Searcher Time Zone : %s", s));
    }

    public static String toCriterionNameBulkString(WebpageParameter webpageParameter, Long id) {
        if (webpageParameter == null || webpageParameter.getCriterionName() == null) {
            return null;
        }
        if (webpageParameter.getCriterionName().isEmpty()) {
            return id != null && id > 0L ? "delete_value" : null;
        }
        return webpageParameter.getCriterionName();
    }

    public static String parseCriterionName(String s) {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        return s;
    }

    public static String toRemarketingRuleBulkString(RemarketingRule remarketingRule) {
        if (remarketingRule == null) {
            return null;
        }
        if (remarketingRule instanceof CustomEventsRule) {
            return String.format("CustomEvents%s", StringExtensions.getCustomEventsRule((CustomEventsRule)remarketingRule));
        }
        if (remarketingRule instanceof PageVisitorsRule) {
            return String.format("PageVisitors%s", StringExtensions.getRuleItemGroups(((PageVisitorsRule)remarketingRule).getRuleItemGroups().getRuleItemGroups()));
        }
        if (remarketingRule instanceof PageVisitorsWhoVisitedAnotherPageRule) {
            return String.format("PageVisitorsWhoVisitedAnotherPage(%s) and (%s)", StringExtensions.getRuleItemGroups(((PageVisitorsWhoVisitedAnotherPageRule)remarketingRule).getRuleItemGroups().getRuleItemGroups()), StringExtensions.getRuleItemGroups(((PageVisitorsWhoVisitedAnotherPageRule)remarketingRule).getAnotherRuleItemGroups().getRuleItemGroups()));
        }
        if (remarketingRule instanceof PageVisitorsWhoDidNotVisitAnotherPageRule) {
            return String.format("PageVisitorsWhoDidNotVisitAnotherPage(%s) and not (%s)", StringExtensions.getRuleItemGroups(((PageVisitorsWhoDidNotVisitAnotherPageRule)remarketingRule).getIncludeRuleItemGroups().getRuleItemGroups()), StringExtensions.getRuleItemGroups(((PageVisitorsWhoDidNotVisitAnotherPageRule)remarketingRule).getExcludeRuleItemGroups().getRuleItemGroups()));
        }
        if (remarketingRule instanceof RemarketingRule) {
            return null;
        }
        throw new IllegalArgumentException("Invalid Remarketing Rule");
    }

    private static String getCustomEventsRule(CustomEventsRule rule) {
        int index;
        if (rule == null) {
            return null;
        }
        ArrayList<String> rules = new ArrayList<String>();
        if (rule.getCategoryOperator() != null && rule.getCategory() != null) {
            rules.add(String.format("Category %s %s", rule.getCategoryOperator().value(), rule.getCategory()));
        }
        if (rule.getActionOperator() != null && rule.getAction() != null) {
            rules.add(String.format("Action %s %s", rule.getActionOperator().value(), rule.getAction()));
        }
        if (rule.getLabelOperator() != null && rule.getLabel() != null) {
            rules.add(String.format("Label %s %s", rule.getLabelOperator().value(), rule.getLabel()));
        }
        if (rule.getValueOperator() != null && rule.getValue() != null) {
            rules.add(String.format("Value %s %s", rule.getValueOperator().value(), rule.getValue()));
        }
        if (rules.size() == 0) {
            throw new IllegalArgumentException("Invalid Custom Events Rule");
        }
        StringBuilder str = new StringBuilder();
        for (index = 0; index < rules.size() - 1; ++index) {
            str.append(String.format("(%s)", rules.get(index)));
            str.append(" and ");
        }
        str.append(String.format("(%s)", rules.get(index)));
        return str.toString();
    }

    private static String getRuleItemGroups(List<RuleItemGroup> ruleItemGroups) {
        int index;
        if (ruleItemGroups == null || ruleItemGroups.size() == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (index = 0; index < ruleItemGroups.size() - 1; ++index) {
            str.append(String.format("(%s)", StringExtensions.getRuleItems(ruleItemGroups.get(index).getItems().getRuleItems())));
            str.append(" or ");
        }
        str.append(String.format("(%s)", StringExtensions.getRuleItems(ruleItemGroups.get(index).getItems().getRuleItems())));
        return str.toString();
    }

    private static String getRuleItems(List<RuleItem> ruleItems) {
        int index;
        if (ruleItems == null || ruleItems.size() == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (index = 0; index < ruleItems.size() - 1; ++index) {
            str.append(StringExtensions.getRuleItem(ruleItems.get(index)));
            str.append(" and ");
        }
        str.append(StringExtensions.getRuleItem(ruleItems.get(index)));
        return str.toString();
    }

    private static String getRuleItem(RuleItem ruleItem) {
        if (ruleItem instanceof StringRuleItem) {
            return String.format("(%s %s %s)", ((StringRuleItem)ruleItem).getOperand(), ((StringRuleItem)ruleItem).getOperator().value(), ((StringRuleItem)ruleItem).getValue());
        }
        return null;
    }

    public static RemarketingRule parseRemarketingRule(String s) {
        if (StringExtensions.isNullOrEmpty(s)) {
            return null;
        }
        int pos = s.indexOf(40);
        if (pos == -1) {
            throw new IllegalArgumentException(String.format("Invalid Remarketing Rule: %s", s));
        }
        String type = s.substring(0, pos);
        String ruleStr = s.substring(pos + 1, s.length() - 1);
        if (type.toLowerCase().equals("pagevisitors")) {
            return StringExtensions.parsePageVisitorsRule(ruleStr);
        }
        if (type.toLowerCase().equals("pagevisitorswhovisitedanotherpage")) {
            return StringExtensions.parsePageVisitorsWhoVisitedAnotherPageRule(ruleStr);
        }
        if (type.toLowerCase().equals("pagevisitorswhodidnotvisitanotherpage")) {
            return StringExtensions.parsePageVisitorsWhoDidNotVisitAnotherPage(ruleStr);
        }
        if (type.toLowerCase().equals("customevents")) {
            return StringExtensions.parseCustomeventsRule(ruleStr);
        }
        throw new IllegalArgumentException(String.format("Invalid Custom Remarketing Rule Type: %s", type));
    }

    private static RemarketingRule parsePageVisitorsRule(String ruleStr) {
        if (StringExtensions.isNullOrEmpty(ruleStr)) {
            return null;
        }
        PageVisitorsRule rule = new PageVisitorsRule();
        rule.setType("PageVisitors");
        rule.setRuleItemGroups(StringExtensions.parseRuleItemGroups(ruleStr));
        return rule;
    }

    private static RemarketingRule parsePageVisitorsWhoVisitedAnotherPageRule(String ruleStr) {
        if (StringExtensions.isNullOrEmpty(ruleStr)) {
            return null;
        }
        PageVisitorsWhoVisitedAnotherPageRule rule = new PageVisitorsWhoVisitedAnotherPageRule();
        rule.setType("PageVisitorsWhoVisitedAnotherPage");
        String[] groups = ruleStr.split("\\)\\)\\) and \\(\\(\\(");
        if (groups != null && groups.length == 2) {
            rule.setRuleItemGroups(StringExtensions.parseRuleItemGroups(groups[0]));
            rule.setAnotherRuleItemGroups(StringExtensions.parseRuleItemGroups(groups[1]));
        }
        return rule;
    }

    private static RemarketingRule parsePageVisitorsWhoDidNotVisitAnotherPage(String ruleStr) {
        if (StringExtensions.isNullOrEmpty(ruleStr)) {
            return null;
        }
        PageVisitorsWhoDidNotVisitAnotherPageRule rule = new PageVisitorsWhoDidNotVisitAnotherPageRule();
        rule.setType("PageVisitorsWhoDidNotVisitAnotherPage");
        String[] groups = ruleStr.split("\\)\\)\\) and not \\(\\(\\(");
        if (groups != null && groups.length == 2) {
            rule.setIncludeRuleItemGroups(StringExtensions.parseRuleItemGroups(groups[0]));
            rule.setExcludeRuleItemGroups(StringExtensions.parseRuleItemGroups(groups[1]));
        }
        return rule;
    }

    private static RemarketingRule parseCustomeventsRule(String ruleStr) {
        String[] ruleItemStrs;
        if (StringExtensions.isNullOrEmpty(ruleStr)) {
            return null;
        }
        CustomEventsRule rule = new CustomEventsRule();
        rule.setType("CustomEvents");
        String ruleItemDelimiter = "\\) and \\(";
        for (String ruleItemStr : ruleItemStrs = ruleStr.split(ruleItemDelimiter)) {
            Matcher operandMatcher = operandPattern.matcher(ruleItemStr = ruleItemStr.replaceAll("\\(", "").replaceAll("\\)", ""));
            if (operandMatcher.find()) {
                String operand = operandMatcher.group(1).toLowerCase();
                String operatorStr = operandMatcher.group(2);
                if (operand.equals("value")) {
                    Matcher numberOperator = numberOperatorPattern.matcher(operatorStr);
                    if (numberOperator.find()) {
                        rule.setValueOperator(StringExtensions.parseNumberOperator(numberOperator.group(1)));
                        rule.setValue(new BigDecimal(numberOperator.group(2)));
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Invalid Custom Events Rule Item Value Operator: %s", operatorStr));
                }
                Matcher stringOperator = stringOperatorPattern.matcher(operatorStr);
                if (stringOperator.find()) {
                    if (operand.equals("category")) {
                        rule.setCategoryOperator(StringExtensions.parseStringOperator(stringOperator.group(1)));
                        rule.setCategory(stringOperator.group(2));
                        continue;
                    }
                    if (operand.equals("label")) {
                        rule.setLabelOperator(StringExtensions.parseStringOperator(stringOperator.group(1)));
                        rule.setLabel(stringOperator.group(2));
                        continue;
                    }
                    if (operand.equals("action")) {
                        rule.setActionOperator(StringExtensions.parseStringOperator(stringOperator.group(1)));
                        rule.setAction(stringOperator.group(2));
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Invalid Custom Events Rule Item Operand: %s", operand));
                }
                throw new IllegalArgumentException(String.format("Invalid Custom Events Rule Item String Operator: %s", operatorStr));
            }
            throw new IllegalArgumentException(String.format("Invalid Custom Events Rule Item: %s", ruleItemStr));
        }
        return rule;
    }

    private static ArrayOfRuleItemGroup parseRuleItemGroups(String groups) {
        String groupDelimiter = "\\)\\) or \\(\\(";
        String[] groupItems = groups.split(groupDelimiter);
        ArrayOfRuleItemGroup ruleItemGroups = new ArrayOfRuleItemGroup();
        for (String group : groupItems) {
            RuleItemGroup ruleItemGroup = StringExtensions.parseRuleItemGroup(group);
            if (ruleItemGroup == null) continue;
            ruleItemGroups.getRuleItemGroups().add(ruleItemGroup);
        }
        return ruleItemGroups;
    }

    private static RuleItemGroup parseRuleItemGroup(String group) {
        String ruleItemDelimiter = "\\) and \\(";
        String[] ruleItems = group.split(ruleItemDelimiter);
        RuleItemGroup ruleItemGroup = new RuleItemGroup();
        ruleItemGroup.setItems(new ArrayOfRuleItem());
        for (String ruleItemStr : ruleItems) {
            StringRuleItem ruleItem = StringExtensions.parseRuleItem(ruleItemStr);
            if (ruleItems == null) continue;
            ruleItemGroup.getItems().getRuleItems().add(ruleItem);
        }
        return ruleItemGroup;
    }

    private static StringRuleItem parseRuleItem(String ruleItemStr) {
        Matcher match = pageRulePattern.matcher(ruleItemStr = ruleItemStr.replaceAll("\\(", "").replaceAll("\\)", ""));
        if (match.find()) {
            StringRuleItem ruleItem = new StringRuleItem();
            ruleItem.setType("String");
            ruleItem.setOperand(match.group(1));
            ruleItem.setOperator(StringExtensions.parseStringOperator(match.group(2)));
            ruleItem.setValue(match.group(3));
            return ruleItem;
        }
        throw new IllegalArgumentException(String.format("Invalid Rule Item: %s", ruleItemStr));
    }

    private static NumberOperator parseNumberOperator(String operator) {
        if (operator == null) {
            return null;
        }
        if ((operator = operator.toLowerCase()).equals("equals")) {
            return NumberOperator.EQUALS;
        }
        if (operator.equals("greaterthan")) {
            return NumberOperator.GREATER_THAN;
        }
        if (operator.equals("lessthan")) {
            return NumberOperator.LESS_THAN;
        }
        if (operator.equals("greaterthanequalto")) {
            return NumberOperator.GREATER_THAN_EQUAL_TO;
        }
        if (operator.equals("lessthanequalto")) {
            return NumberOperator.LESS_THAN_EQUAL_TO;
        }
        throw new IllegalArgumentException(String.format("Invalid Number Rule Item operator: ", operator));
    }

    private static StringOperator parseStringOperator(String operator) {
        if (operator == null) {
            return null;
        }
        if ((operator = operator.toLowerCase()).equals("equals")) {
            return StringOperator.EQUALS;
        }
        if (operator.equals("contains")) {
            return StringOperator.CONTAINS;
        }
        if (operator.equals("beginswith")) {
            return StringOperator.BEGINS_WITH;
        }
        if (operator.equals("endswith")) {
            return StringOperator.ENDS_WITH;
        }
        if (operator.equals("notequals")) {
            return StringOperator.NOT_EQUALS;
        }
        if (operator.equals("doesnotcontain")) {
            return StringOperator.DOES_NOT_CONTAIN;
        }
        if (operator.equals("doesnotbeginwith")) {
            return StringOperator.DOES_NOT_BEGIN_WITH;
        }
        if (operator.equals("doesnotendwith")) {
            return StringOperator.DOES_NOT_END_WITH;
        }
        throw new IllegalArgumentException(String.format("Invalid String Rule Item perator: ", operator));
    }

    public static String toBulkString(TargetSetting targetSetting) {
        if (targetSetting == null) {
            return null;
        }
        if (targetSetting.getDetails() == null || targetSetting.getDetails().getTargetSettingDetails().size() == 0) {
            return "delete_value";
        }
        return String.join((CharSequence)"; ", (CharSequence[])targetSetting.getDetails().getTargetSettingDetails().stream().filter(e -> e.getTargetAndBid()).map(e -> e.getCriterionTypeGroup().value()).toArray(CharSequence[]::new));
    }

    public static List<TargetSettingDetail> parseTargetSettingDetails(String details) {
        if (details == null || details.length() == 0) {
            return null;
        }
        return Arrays.stream(details.split(";")).map(s -> s.trim()).map(s -> {
            Matcher m = targetSettingDetailsPattern.matcher((CharSequence)s);
            if (m.matches()) {
                return m.group(1);
            }
            return null;
        }).filter(s -> s != null).map(s -> {
            TargetSettingDetail targetSettingDetail = new TargetSettingDetail();
            targetSettingDetail.setCriterionTypeGroup(CriterionTypeGroup.fromValue(s));
            targetSettingDetail.setTargetAndBid(true);
            return targetSettingDetail;
        }).collect(Collectors.toList());
    }

    public static String writeArrayOfstring(ArrayOfstring arrayOfString, String separator) {
        if (arrayOfString == null) {
            return null;
        }
        if (arrayOfString.getStrings().size() == 0) {
            return null;
        }
        return String.join((CharSequence)separator, arrayOfString.getStrings());
    }

    public static ArrayOfstring parseArrayOfString(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        String[] parts = value.split(";");
        ArrayOfstring ret = new ArrayOfstring();
        ret.getStrings().addAll(Arrays.stream(parts).map(s -> s.trim()).filter(s -> s.length() > 0 && false == ";".equals(s)).collect(Collectors.toList()));
        return ret;
    }

    public static Collection<ProductAudienceType> parseProductAudienceType(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            return null;
        }
        String[] parts = value.split(";");
        return Arrays.stream(parts).map(s -> s.trim()).map(p -> ProductAudienceType.fromValue(p)).collect(Collectors.toList());
    }

    public static String toImageAssetLinksBulkString(ArrayOfAssetLink arrayOfAssetLink) {
        if (arrayOfAssetLink == null || arrayOfAssetLink.getAssetLinks() == null || arrayOfAssetLink.getAssetLinks().size() == 0) {
            return null;
        }
        List assetLinks = arrayOfAssetLink.getAssetLinks().stream().filter(s -> "ImageAsset".equals(s.getAsset().getType())).collect(Collectors.toList());
        if (assetLinks.size() == 0) {
            return null;
        }
        ArrayList<ImageAssetLinkContract> imageAssetLinkContracts = new ArrayList<ImageAssetLinkContract>(assetLinks.size());
        for (AssetLink assetLink : assetLinks) {
            ImageAsset asset = (ImageAsset)assetLink.getAsset();
            ImageAssetLinkContract contract = new ImageAssetLinkContract();
            contract.assetPerformanceLabel = assetLink.getAssetPerformanceLabel();
            contract.cropHeight = asset.getCropHeight();
            contract.cropWidth = asset.getCropWidth();
            contract.cropX = asset.getCropX();
            contract.cropY = asset.getCropY();
            contract.id = asset.getId();
            contract.editorialStatus = assetLink.getEditorialStatus() == null ? null : assetLink.getEditorialStatus().value();
            contract.name = asset.getName();
            contract.pinnedField = assetLink.getPinnedField();
            contract.subType = asset.getSubType();
            imageAssetLinkContracts.add(contract);
        }
        try {
            return new ObjectMapper().writeValueAsString(imageAssetLinkContracts);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayOfAssetLink parseImageAssetLinks(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            ArrayOfAssetLink assetLinks = new ArrayOfAssetLink();
            List imageAssetLinkContracts = (List)mapper.readValue(value, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, ImageAssetLinkContract.class));
            for (ImageAssetLinkContract contract : imageAssetLinkContracts) {
                AssetLink assetLink = new AssetLink();
                if (contract.editorialStatus != null) {
                    assetLink.setEditorialStatus(AssetLinkEditorialStatus.fromValue(contract.editorialStatus));
                }
                assetLink.setAssetPerformanceLabel(contract.assetPerformanceLabel);
                assetLink.setPinnedField(contract.pinnedField);
                ImageAsset asset = new ImageAsset();
                asset.setId(contract.id);
                asset.setName(contract.name);
                asset.setCropHeight(contract.cropHeight);
                asset.setCropWidth(contract.cropWidth);
                asset.setCropX(contract.cropX);
                asset.setCropY(contract.cropY);
                asset.setSubType(contract.subType);
                asset.setType("ImageAsset");
                assetLink.setAsset(asset);
                assetLinks.getAssetLinks().add(assetLink);
            }
            return assetLinks;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toTextAssetLinksBulkString(ArrayOfAssetLink arrayOfAssetLink) {
        if (arrayOfAssetLink == null || arrayOfAssetLink.getAssetLinks() == null || arrayOfAssetLink.getAssetLinks().size() == 0) {
            return null;
        }
        List assetLinks = arrayOfAssetLink.getAssetLinks().stream().filter(s -> "TextAsset".equals(s.getAsset().getType())).collect(Collectors.toList());
        if (assetLinks.size() == 0) {
            return null;
        }
        ArrayList<TextAssetLinkContract> textAssetLinkContracts = new ArrayList<TextAssetLinkContract>(assetLinks.size());
        for (AssetLink assetLink : assetLinks) {
            TextAssetLinkContract textAssetLinkContract = new TextAssetLinkContract();
            textAssetLinkContract.editorialStatus = assetLink.getEditorialStatus() == null ? null : assetLink.getEditorialStatus().value();
            textAssetLinkContract.id = assetLink.getAsset().getId();
            textAssetLinkContract.name = assetLink.getAsset().getName();
            textAssetLinkContract.pinnedField = assetLink.getPinnedField();
            textAssetLinkContract.text = ((TextAsset)assetLink.getAsset()).getText();
            textAssetLinkContract.assetPerformanceLabel = assetLink.getAssetPerformanceLabel();
            textAssetLinkContracts.add(textAssetLinkContract);
        }
        try {
            return new ObjectMapper().writeValueAsString(textAssetLinkContracts);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayOfAssetLink parseTextAssetLinks(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            ArrayOfAssetLink assetLinks = new ArrayOfAssetLink();
            List textAssetLinkContracts = (List)mapper.readValue(value, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, TextAssetLinkContract.class));
            for (TextAssetLinkContract contract : textAssetLinkContracts) {
                AssetLink assetLink = new AssetLink();
                if (contract.editorialStatus != null) {
                    assetLink.setEditorialStatus(AssetLinkEditorialStatus.fromValue(contract.editorialStatus));
                }
                assetLink.setAssetPerformanceLabel(contract.assetPerformanceLabel);
                assetLink.setPinnedField(contract.pinnedField);
                TextAsset asset = new TextAsset();
                asset.setId(contract.id);
                asset.setName(contract.name);
                asset.setText(contract.text);
                asset.setType("TextAsset");
                assetLink.setAsset(asset);
                assetLinks.getAssetLinks().add(assetLink);
            }
            return assetLinks;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toActionAdExtensionActionTypeBulkString(ActionAdExtensionActionType type) {
        if (type == null) {
            return null;
        }
        return type.value();
    }

    private static class TextAssetLinkContract {
        @JsonProperty
        public long id;
        @JsonProperty
        public String text;
        @JsonProperty
        public String pinnedField;
        @JsonProperty
        public String editorialStatus;
        @JsonProperty
        public String assetPerformanceLabel;
        @JsonProperty
        public String name;

        private TextAssetLinkContract() {
        }
    }

    private static class ImageAssetLinkContract {
        public long id;
        public String subType;
        public int cropHeight;
        public int cropWidth;
        public int cropX;
        public int cropY;
        public String pinnedField;
        public String editorialStatus;
        public String assetPerformanceLabel;
        public String name;

        private ImageAssetLinkContract() {
        }
    }
}

